/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.boot.web.server.WebServer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ResourceUtils;
import org.springframework.web.method.HandlerMethod;
import sun.reflect.annotation.AnnotationParser;

public final class SpringUtils {
    public static final String SPRING_BOOT_SERVER_PORT = "server.port";
    public static final String SPRING_BOOT_CONTEXT_PATH = "server.servlet.context-path";

    public static Resource getResource(String resourceLocation) throws IOException {
        URL url = ResourceUtils.getURL((String)resourceLocation);
        byte[] bytes = IOUtils.toByteArray((URL)url);
        return new InputStreamResource((InputStream)new ByteArrayInputStream(bytes));
    }

    public static int getActualWebServerPort(WebServerApplicationContext webServerApplicationContext) {
        Integer port = (Integer)webServerApplicationContext.getEnvironment().getProperty(SPRING_BOOT_SERVER_PORT, Integer.class);
        if (port != null && port > 0) {
            return port;
        }
        WebServer webServer = webServerApplicationContext.getWebServer();
        webServer.start();
        return webServer.getPort();
    }

    public static <T extends Annotation> T getAnnotation(Class<T> type, HandlerMethod handlerMethod) {
        Annotation annotation = handlerMethod.getMethodAnnotation(type);
        return (T)(annotation != null ? annotation : handlerMethod.getBeanType().getAnnotation(type));
    }

    public static AnnotationAttributes getAnnotationAttributes(Class<? extends Annotation> type, AnnotatedTypeMetadata metadata) {
        return AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(type.getName()));
    }

    public static <T extends Annotation> T parseAnnotation(Class<T> type, AnnotatedTypeMetadata metadata) {
        Map attributes = metadata.getAnnotationAttributes(type.getName());
        if (attributes == null) {
            throw new IllegalArgumentException("Not found annotated type: " + type);
        }
        return SpringUtils.parseAnnotation(type, attributes);
    }

    public static <T extends Annotation> T parseAnnotation(Class<T> type, Map<String, Object> attributes) {
        return (T)AnnotationParser.annotationForMap(type, attributes == null ? Collections.emptyMap() : attributes);
    }

    public static void addPropertyIfAbsent(Environment environment, String key, String value) {
        if (environment instanceof ConfigurableEnvironment && StringUtils.isEmpty((CharSequence)environment.getProperty(key))) {
            Properties properties = new Properties();
            properties.setProperty(key, value);
            PropertiesPropertySource propertySource = new PropertiesPropertySource(key, properties);
            ((ConfigurableEnvironment)environment).getPropertySources().addFirst((PropertySource)propertySource);
        }
    }
}

