/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.exception.Throwables;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionUtils {
    private static final int AFFECTED_ONE_ROW = 1;

    public static boolean isNotAffectedRow(int totalAffectedRow) {
        return totalAffectedRow < 1;
    }

    public static boolean isOneAffectedRow(int totalAffectedRow) {
        return totalAffectedRow == 1;
    }

    public static boolean hasAffectedRow(int totalAffectedRow) {
        return totalAffectedRow >= 1;
    }

    public static void assertNotAffectedRow(int totalAffectedRow, Supplier<String> errorMsgSupplier) {
        if (totalAffectedRow >= 1) {
            throw new IllegalStateException(errorMsgSupplier.get());
        }
    }

    public static void assertNotAffectedRow(int totalAffectedRow, String errorMsg) {
        if (totalAffectedRow >= 1) {
            throw new IllegalStateException(errorMsg);
        }
    }

    public static void assertOneAffectedRow(int totalAffectedRow, Supplier<String> errorMsgSupplier) {
        if (totalAffectedRow != 1) {
            throw new IllegalStateException(errorMsgSupplier.get());
        }
    }

    public static void assertOneAffectedRow(int totalAffectedRow, String errorMsg) {
        if (totalAffectedRow != 1) {
            throw new IllegalStateException(errorMsg);
        }
    }

    public static void assertHasAffectedRow(int totalAffectedRow, Supplier<String> errorMsgSupplier) {
        if (totalAffectedRow < 1) {
            throw new IllegalStateException(errorMsgSupplier.get());
        }
    }

    public static void assertHasAffectedRow(int totalAffectedRow, String errorMsg) {
        if (totalAffectedRow < 1) {
            throw new IllegalStateException(errorMsg);
        }
    }

    public static void doAfterTransactionCommit(final Runnable action) {
        if (action == null) {
            return;
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronization ts = new TransactionSynchronization(){

                public void afterCommit() {
                    action.run();
                }
            };
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)ts);
        } else {
            action.run();
        }
    }

    public static void doInRequiresNewTransaction(PlatformTransactionManager txManager, Throwables.ThrowingRunnable<Throwable> action, Consumer<Throwable> errorHandler) {
        TransactionUtils.doInPropagationTransaction(txManager, action, errorHandler, 3);
    }

    public static void doInNestedTransaction(TransactionTemplate transactionTemplate, Throwables.ThrowingRunnable<Throwable> action, Consumer<Throwable> errorHandler) {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new IllegalStateException("Do nested transaction must be in parent transaction.");
        }
        PlatformTransactionManager txManager = transactionTemplate.getTransactionManager();
        TransactionUtils.doInPropagationTransaction(txManager, action, errorHandler, 6);
    }

    private static void doInPropagationTransaction(PlatformTransactionManager txManager, Throwables.ThrowingRunnable<Throwable> action, Consumer<Throwable> errorHandler, int transactionPropagation) {
        Objects.requireNonNull(txManager, "Transaction manager cannot be null.");
        DefaultTransactionDefinition txDefinition = new DefaultTransactionDefinition();
        txDefinition.setPropagationBehavior(transactionPropagation);
        TransactionStatus status = txManager.getTransaction((TransactionDefinition)txDefinition);
        try {
            action.run();
            txManager.commit(status);
        }
        catch (Throwable t) {
            txManager.rollback(status);
            errorHandler.accept(t);
        }
    }
}

