/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.DefaultPropertySourceFactory;
import org.springframework.core.io.support.EncodedResource;

public class YamlPropertySourceFactory
extends DefaultPropertySourceFactory {
    public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
        String sourceName;
        String string = sourceName = name != null ? name : resource.getResource().getFilename();
        if (!resource.getResource().exists()) {
            return new PropertiesPropertySource(sourceName, new Properties());
        }
        if (StringUtils.endsWithAny((CharSequence)sourceName, (CharSequence[])new CharSequence[]{".yml", ".yaml"})) {
            return new PropertiesPropertySource(sourceName, YamlPropertySourceFactory.loadYml(resource.getResource()));
        }
        return super.createPropertySource(name, resource);
    }

    public static Properties loadYml(Resource resource) {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{resource});
        factory.afterPropertiesSet();
        return factory.getObject();
    }
}

