/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.tree;

import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.tree.BaseNode;
import cn.ponfee.disjob.common.tree.FlatNode;
import cn.ponfee.disjob.common.tree.TreeNodeBuilder;
import cn.ponfee.disjob.common.tree.TreeTrait;
import cn.ponfee.disjob.common.tree.print.MultiwayTreePrinter;
import cn.ponfee.disjob.common.util.Fields;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class TreeNode<T extends Serializable & Comparable<T>, A>
extends BaseNode<T, A> {
    private static final long serialVersionUID = -9081626363752680404L;
    private final Comparator<? super TreeNode<T, A>> siblingNodesComparator;
    private final LinkedList<TreeNode<T, A>> children = new LinkedList();
    private final boolean buildPath;

    TreeNode(T nid, T pid, boolean enabled, boolean available, A attach, Comparator<? super TreeNode<T, A>> siblingNodesComparator, boolean buildPath, boolean doMount) {
        super(nid, pid, enabled, available, attach);
        this.siblingNodesComparator = Objects.requireNonNull(siblingNodesComparator);
        this.buildPath = buildPath;
        if (doMount) {
            this.mount(null);
        }
    }

    public static <T extends Serializable & Comparable<T>, A> TreeNodeBuilder<T, A> builder(T nid) {
        return new TreeNodeBuilder(nid);
    }

    public <E extends BaseNode<T, A>> TreeNode<T, A> mount(List<E> nodes) {
        this.mount(nodes, false);
        return this;
    }

    public <E extends BaseNode<T, A>> TreeNode<T, A> mount(List<E> list, boolean ignoreOrphan) {
        if (list == null) {
            list = Collections.emptyList();
        }
        List<BaseNode<BaseNode, A>> nodes = this.prepare(list);
        LinkedList checkDuplicateList = Collects.newLinkedList(this.nid);
        nodes.forEach(n -> checkDuplicateList.add(n.nid));
        List duplicated = Collects.duplicate(checkDuplicateList);
        if (CollectionUtils.isNotEmpty(duplicated)) {
            throw new IllegalStateException("Duplicated nodes: " + duplicated);
        }
        this.level = 1;
        this.path = null;
        this.leftLeafCount = 0;
        this.siblingOrdinal = 1;
        this.mount0(null, nodes, ignoreOrphan, this.nid);
        if (!ignoreOrphan && CollectionUtils.isNotEmpty(nodes)) {
            String nids = nodes.stream().map(e -> String.valueOf(e.getNid())).collect(Collectors.joining(","));
            throw new IllegalStateException("Invalid orphan nodes: [" + nids + "]");
        }
        this.count();
        return this;
    }

    public List<FlatNode<T, A>> flatDFS() {
        LinkedList collect = Lists.newLinkedList();
        LinkedList<TreeNode> stack = Collects.newLinkedList(this);
        while (!stack.isEmpty()) {
            TreeNode node = (TreeNode)stack.pop();
            collect.add(new FlatNode(node));
            node.ifChildrenPresent(cs -> {
                Iterator iter = cs.descendingIterator();
                while (iter.hasNext()) {
                    stack.push((TreeNode)iter.next());
                }
            });
        }
        return collect;
    }

    public List<FlatNode<T, A>> flatCFS() {
        LinkedList collect = Collects.newLinkedList(new FlatNode(this));
        LinkedList<TreeNode> stack = Collects.newLinkedList(this);
        while (!stack.isEmpty()) {
            TreeNode node = (TreeNode)stack.pop();
            node.ifChildrenPresent(cs -> {
                cs.forEach(child -> collect.add(new FlatNode(child)));
                Iterator iter = cs.descendingIterator();
                while (iter.hasNext()) {
                    stack.push((TreeNode)iter.next());
                }
            });
        }
        return collect;
    }

    public List<FlatNode<T, A>> flatBFS() {
        LinkedList<FlatNode<T, A>> collect = new LinkedList<FlatNode<T, A>>();
        LinkedList<TreeNode> queue = Collects.newLinkedList(this);
        while (!queue.isEmpty()) {
            for (int i = queue.size(); i > 0; --i) {
                TreeNode node = (TreeNode)queue.poll();
                collect.add(new FlatNode(node));
                node.forEachChild(queue::offer);
            }
        }
        return collect;
    }

    public void ifChildrenPresent(Consumer<LinkedList<TreeNode<T, A>>> childrenProcessor) {
        if (!this.children.isEmpty()) {
            childrenProcessor.accept(this.children);
        }
    }

    public void forEachChild(Consumer<TreeNode<T, A>> childProcessor) {
        if (!this.children.isEmpty()) {
            this.children.forEach(childProcessor);
        }
    }

    public void traverse(Consumer<TreeNode<T, A>> action) {
        LinkedList<TreeNode> stack = Collects.newLinkedList(this);
        while (!stack.isEmpty()) {
            TreeNode node = (TreeNode)stack.pop();
            action.accept(node);
            node.forEachChild(stack::push);
        }
    }

    public <E extends TreeTrait<T, A, E>> E convert(Function<TreeNode<T, A>, E> convert) {
        return this.convert(convert, true);
    }

    public <E extends TreeTrait<T, A, E>> E convert(Function<TreeNode<T, A>, E> convert, boolean containsUnavailable) {
        if (!this.available && !containsUnavailable) {
            return null;
        }
        TreeTrait root = (TreeTrait)convert.apply(this);
        this.convert(convert, root, containsUnavailable);
        return (E)root;
    }

    public String print(Function<TreeNode<T, A>, CharSequence> nodeLabel) throws IOException {
        StringBuilder builder = new StringBuilder();
        new MultiwayTreePrinter<TreeNode>(builder, nodeLabel, TreeNode::getChildren).print(this);
        return builder.toString();
    }

    public String toString() {
        try {
            return this.print(e -> String.valueOf(e.getNid()));
        }
        catch (IOException e2) {
            return (String)ExceptionUtils.rethrow((Throwable)e2);
        }
    }

    public LinkedList<TreeNode<T, A>> getChildren() {
        return this.children;
    }

    private <E extends BaseNode<T, A>> List<BaseNode<T, A>> prepare(List<E> nodes) {
        LinkedList list = Lists.newLinkedList();
        for (BaseNode node : nodes) {
            if (node instanceof TreeNode) {
                ((TreeNode)node).traverse(list::add);
                continue;
            }
            list.add(node);
        }
        this.ifChildrenPresent(cs -> {
            cs.forEach(child -> child.traverse(list::add));
            cs.clear();
        });
        return list;
    }

    private <E extends BaseNode<T, A>> void mount0(List<T> parentPath, List<E> nodes, boolean ignoreOrphan, T mountPidIfNull) {
        this.path = this.buildPath(parentPath, this.nid);
        Iterator<E> iter = nodes.iterator();
        while (iter.hasNext()) {
            BaseNode node = (BaseNode)iter.next();
            if (!ignoreOrphan && ObjectUtils.isEmpty(node.pid)) {
                Fields.put((Object)node, "pid", mountPidIfNull);
            }
            if (!this.nid.equals(node.pid)) continue;
            TreeNode child = new TreeNode(node.nid, node.pid, node.enabled, this.available && node.enabled, node.attach, this.siblingNodesComparator, this.buildPath, false);
            child.level = this.level + 1;
            this.children.add(child);
            iter.remove();
        }
        this.ifChildrenPresent(cs -> {
            cs.forEach(child -> child.mount0(this.path, nodes, ignoreOrphan, mountPidIfNull));
            cs.sort(this.siblingNodesComparator);
        });
        this.degree = this.children.size();
    }

    private void count() {
        if (this.children.isEmpty()) {
            this.treeDepth = 1;
            this.treeMaxDegree = 0;
            this.treeLeafCount = 1;
            this.treeNodeCount = 1;
            this.childrenCount = 0;
            return;
        }
        int maxChildTreeDepth = 0;
        int maxChildTreeMaxDegree = 0;
        int sumChildrenTreeLeafCount = 0;
        int sumChildrenTreeNodeCount = 0;
        for (int i = 0; i < this.children.size(); ++i) {
            TreeNode<T, A> child = this.children.get(i);
            child.siblingOrdinal = i + 1;
            if (i == 0) {
                child.leftLeafCount = this.leftLeafCount;
            } else {
                TreeNode<T, A> prevSibling = this.children.get(i - 1);
                child.leftLeafCount = prevSibling.leftLeafCount + prevSibling.treeLeafCount;
            }
            super.count();
            maxChildTreeDepth = Math.max(maxChildTreeDepth, child.treeDepth);
            maxChildTreeMaxDegree = Math.max(maxChildTreeMaxDegree, child.degree);
            sumChildrenTreeLeafCount += child.treeLeafCount;
            sumChildrenTreeNodeCount += child.treeNodeCount;
        }
        this.treeDepth = maxChildTreeDepth + 1;
        this.treeMaxDegree = Math.max(maxChildTreeMaxDegree, this.degree);
        this.treeLeafCount = sumChildrenTreeLeafCount;
        this.treeNodeCount = sumChildrenTreeNodeCount + 1;
        this.childrenCount = this.children.size();
    }

    private List<T> buildPath(List<T> parentPath, T nid) {
        if (!this.buildPath) {
            return null;
        }
        if (parentPath == null) {
            return Collections.singletonList(nid);
        }
        return ImmutableList.builderWithExpectedSize((int)(parentPath.size() + 1)).addAll(parentPath).add(nid).build();
    }

    private <E extends TreeTrait<T, A, E>> void convert(Function<TreeNode<T, A>, E> convert, E parent, boolean containsUnavailable) {
        if (this.children.isEmpty()) {
            parent.setChildren(null);
            return;
        }
        LinkedList<TreeTrait> list = new LinkedList<TreeTrait>();
        for (TreeNode treeNode : this.children) {
            if (!treeNode.available && !containsUnavailable) continue;
            TreeTrait node = (TreeTrait)convert.apply(treeNode);
            treeNode.convert(convert, node, containsUnavailable);
            list.add(node);
        }
        parent.setChildren(list);
    }
}

