/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

public class Enums {
    public static <E extends Enum<E>> ImmutableMap<String, E> toMap(Class<E> enumType) {
        return Enums.toMap(enumType, Enum::name);
    }

    public static <K, E extends Enum<E>> ImmutableMap<K, E> toMap(Class<E> enumType, Function<E, K> keyMapper) {
        return (ImmutableMap)Arrays.stream(enumType.getEnumConstants()).collect(ImmutableMap.toImmutableMap(keyMapper, Function.identity()));
    }

    public static <E extends Enum<E>> void checkDuplicated(Class<E> enumType, Function<E, ?> mapper) {
        Enum[] values = (Enum[])enumType.getEnumConstants();
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                Object v2;
                Object v1 = mapper.apply(values[i]);
                if (!Objects.equals(v1, v2 = mapper.apply(values[j]))) continue;
                throw new Error(enumType.getSimpleName() + " enums duplicated job error code: " + v1);
            }
        }
    }
}

