/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import cn.ponfee.disjob.common.collect.PooledObjectProcessor;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.SimpleBindings;
import org.apache.commons.codec.digest.DigestUtils;
import org.codehaus.groovy.jsr223.GroovyScriptEngineFactory;

public final class GroovyUtils {
    private static final GroovyClassLoader CLASS_LOADER = new GroovyClassLoader();
    private static final ConcurrentMap<String, Class<?>> CLASS_CACHE = new ConcurrentHashMap();
    private static final GroovyShell GROOVY_SHELL = new GroovyShell();

    public static <T> Class<T> parseClass(String sourceCode) {
        String sha1 = DigestUtils.sha1Hex((String)sourceCode);
        return CLASS_CACHE.computeIfAbsent(sha1, key -> CLASS_LOADER.parseClass(sourceCode));
    }

    public static enum Evaluator {
        CLOSURE{
            final ConcurrentMap<String, Script> scripCache = new ConcurrentHashMap<String, Script>();

            @Override
            protected <T> T evaluate(String scriptText, Map<String, Object> params) {
                Script script = this.scripCache.computeIfAbsent(scriptText, arg_0 -> ((GroovyShell)GROOVY_SHELL).parse(arg_0));
                Closure closure = (Closure)script.run();
                return (T)closure.call(params);
            }
        }
        ,
        SHELL{
            final PooledObjectProcessor<String, Script> pool = new PooledObjectProcessor<String, Script>(10, arg_0 -> ((GroovyShell)GroovyUtils.access$100()).parse(arg_0));

            @Override
            protected <T> T evaluate(String scriptText, Map<String, Object> params) throws Exception {
                return (T)this.pool.process(scriptText, script -> {
                    script.setBinding(new Binding(params));
                    return script.run();
                });
            }
        }
        ,
        SCRIPT{
            final GroovyScriptEngineFactory scriptEngineFactory = new GroovyScriptEngineFactory();

            @Override
            protected <T> T evaluate(String scriptText, Map<String, Object> params) throws Exception {
                ScriptEngine scriptEngine = this.scriptEngineFactory.getScriptEngine();
                return (T)scriptEngine.eval(scriptText, (Bindings)new SimpleBindings(params));
            }
        }
        ,
        CLASS{

            @Override
            protected <T> T evaluate(String scriptText, Map<String, Object> params) throws Exception {
                Class clazz = GroovyUtils.parseClass(scriptText);
                Script script = (Script)clazz.newInstance();
                script.setBinding(new Binding(params));
                return (T)script.run();
            }
        };


        public final <T> T eval(String scriptText, Map<String, Object> params) throws Exception {
            return this.evaluate(scriptText, params == null ? Collections.emptyMap() : params);
        }

        protected abstract <T> T evaluate(String var1, Map<String, Object> var2) throws Exception;
    }
}

