/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import cn.ponfee.disjob.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.disjob.common.util.Fields;
import cn.ponfee.disjob.common.util.Files;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessUtils.class);
    private static final long INVALID_PID = -1L;
    public static final int SUCCESS_CODE = 0;

    public static int progress(Process process, Charset charset, Logger log) {
        return ProcessUtils.progress(process, charset, arg_0 -> ((Logger)log).info(arg_0), arg_0 -> ((Logger)log).error(arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int progress(Process process, Charset charset, Consumer<String> verbose, Consumer<String> error) {
        ThreadPoolExecutors.commonThreadPool().execute(() -> ProcessUtils.read(process.getInputStream(), charset, verbose));
        ThreadPoolExecutors.commonThreadPool().execute(() -> ProcessUtils.read(process.getErrorStream(), charset, error));
        try {
            int n = process.waitFor();
            return n;
        }
        catch (InterruptedException e) {
            error.accept("Process execute interrupted: " + ExceptionUtils.getStackTrace((Throwable)e));
            Thread.currentThread().interrupt();
            int n = -1;
            return n;
        }
        finally {
            try {
                process.destroy();
            }
            catch (Throwable t) {
                verbose.accept("Destroy process error: " + ExceptionUtils.getStackTrace((Throwable)t));
            }
        }
    }

    public static void destroy(Process process) {
        if (process == null) {
            return;
        }
        try {
            process.destroy();
        }
        catch (Throwable t) {
            LOG.error("Destroy process " + process.getClass().getName() + " error.", t);
        }
    }

    public static Long getCurrentJvmProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(name.split("@")[0]);
    }

    public static Long getProcessId(Process process) {
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                long handlePointer = (Long)Fields.get((Object)process, "handle");
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant((long)handlePointer));
                return Kernel32.INSTANCE.GetProcessId(handle);
            }
            if (SystemUtils.IS_OS_UNIX) {
                Integer pid = (Integer)Fields.get((Object)process, "pid");
                return pid.longValue();
            }
            LOG.error("Get process id unknown os name: {}, {}", (Object)SystemUtils.OS_NAME, (Object)process.getClass().getName());
            return -1L;
        }
        catch (Throwable t) {
            LOG.error("Get process id error.", t);
            return -1L;
        }
    }

    public static void killProcess(Long pid, Charset charset) {
        block19: {
            try {
                if (SystemUtils.IS_OS_WINDOWS) {
                    Process killProcess = new ProcessBuilder("taskkill", "/PID", String.valueOf(pid), "/F", "/T").start();
                    ProcessUtils.waitFor(killProcess, () -> "kill process id " + pid);
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Stop windows process verbose: {}, {}", (Object)pid, (Object)ProcessUtils.processVerbose(killProcess, charset));
                    }
                    ProcessUtils.destroy(killProcess);
                    break block19;
                }
                if (SystemUtils.IS_OS_UNIX) {
                    String findChildPidCommand = String.format("ps axo pid,ppid | awk '{ if($2==%d) print$1}'", pid);
                    Process findChildPidProcess = new ProcessBuilder("/bin/sh", "-c", findChildPidCommand).start();
                    ProcessUtils.waitFor(findChildPidProcess, () -> "find child process id for " + pid);
                    try (InputStream inputStream = findChildPidProcess.getInputStream();){
                        List childPidList = IOUtils.readLines((InputStream)inputStream, (Charset)charset);
                        childPidList.stream().filter(StringUtils::isNotBlank).forEach(e -> ProcessUtils.killProcess(Long.parseLong(e.trim()), charset));
                    }
                    ProcessUtils.destroy(findChildPidProcess);
                    Process killProcess = new ProcessBuilder("kill", "-9", String.valueOf(pid)).start();
                    ProcessUtils.waitFor(killProcess, () -> "kill process id " + pid);
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Stop unix process verbose: {}, {}", (Object)pid, (Object)ProcessUtils.processVerbose(killProcess, charset));
                    }
                    ProcessUtils.destroy(killProcess);
                    break block19;
                }
                LOG.error("Stop process id unknown os name: {}, {}", (Object)SystemUtils.OS_NAME, (Object)pid);
            }
            catch (InterruptedException e2) {
                LOG.error("Kill process id '{}' interrupted.", (Object)pid);
                ExceptionUtils.rethrow((Throwable)e2);
            }
            catch (Throwable t) {
                LOG.error("Kill process id '" + pid + "' error.", t);
            }
        }
    }

    private static void read(InputStream input, Charset charset, Consumer<String> consumer) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, charset));){
            String line;
            while (!Thread.currentThread().isInterrupted() && (line = reader.readLine()) != null) {
                consumer.accept(line);
                consumer.accept(Files.SYSTEM_LINE_SEPARATOR);
            }
        }
        catch (IOException e) {
            consumer.accept("Read output error: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private static String processVerbose(Process process, Charset charset) throws IOException {
        try (InputStream input = process.getInputStream();){
            String string = IOUtils.toString((InputStream)input, (Charset)charset);
            return string;
        }
    }

    private static void waitFor(Process process, Supplier<String> messageSupplier) throws InterruptedException {
        int code = process.waitFor();
        if (code != 0) {
            LOG.error("Process execute failed[{}]: {}", (Object)code, (Object)messageSupplier.get());
        }
    }
}

