/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import cn.ponfee.disjob.common.util.Fields;
import java.lang.reflect.Proxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.support.AopUtils;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.InvocationHandler;

public final class ProxyUtils {
    public static <T> T create(java.lang.reflect.InvocationHandler invocationHandler, Class<?> ... interfaces) {
        return (T)Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, invocationHandler);
    }

    public static <T> T create(InvocationHandler invocationHandler, Class<?> superClass) {
        return (T)Enhancer.create(superClass, (Callback)invocationHandler);
    }

    public static <T, H extends java.lang.reflect.InvocationHandler & InvocationHandler> T create(H invocationHandler, Class<?> cls) {
        if (cls.isInterface()) {
            return ProxyUtils.create(invocationHandler, new Class[]{cls});
        }
        return ProxyUtils.create(invocationHandler, cls);
    }

    public static Object getTargetObject(Object object) throws Exception {
        if (!AopUtils.isAopProxy((Object)object)) {
            return object;
        }
        if (object instanceof Advised) {
            return ((Advised)object).getTargetSource().getTarget();
        }
        if (AopUtils.isJdkDynamicProxy((Object)object)) {
            return ProxyUtils.getProxyTargetObject(Fields.get(object, "h"));
        }
        if (AopUtils.isCglibProxy((Object)object)) {
            return ProxyUtils.getProxyTargetObject(Fields.get(object, "CGLIB$CALLBACK_0"));
        }
        return object;
    }

    private static Object getProxyTargetObject(Object proxy) throws Exception {
        AdvisedSupport advisedSupport = (AdvisedSupport)Fields.get(proxy, "advised");
        return advisedSupport.getTargetSource().getTarget();
    }
}

