/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import com.google.common.collect.ImmutableList;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public final class Strings {
    private static final List<String> SQL_LIKE_LIST = ImmutableList.of((Object)"^", (Object)"$", (Object)"^$");

    public static boolean isMatch(String s, String p) {
        int i;
        int m = s.length();
        int n = p.length();
        boolean[][] dp = new boolean[m + 1][n + 1];
        dp[0][0] = true;
        for (i = 1; i <= n && p.charAt(i - 1) == '*'; ++i) {
            dp[0][i] = true;
        }
        for (i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                if (p.charAt(j - 1) == '*') {
                    dp[i][j] = dp[i][j - 1] || dp[i - 1][j];
                    continue;
                }
                if (p.charAt(j - 1) != '?' && s.charAt(i - 1) != p.charAt(j - 1)) continue;
                dp[i][j] = dp[i - 1][j - 1];
            }
        }
        return dp[m][n];
    }

    public static String toSeparatedFormat(String camelcaseFormat, char separator) {
        if (StringUtils.isEmpty((CharSequence)camelcaseFormat)) {
            return camelcaseFormat;
        }
        StringBuilder result = new StringBuilder(camelcaseFormat.length() << 1);
        result.append(Character.toLowerCase(camelcaseFormat.charAt(0)));
        int len = camelcaseFormat.length();
        for (int i = 1; i < len; ++i) {
            char ch = camelcaseFormat.charAt(i);
            if (Character.isUpperCase(ch)) {
                result.append(separator).append(Character.toLowerCase(ch));
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static String toCamelCaseFormat(String separatedFormat, char separator) {
        if (StringUtils.isEmpty((CharSequence)separatedFormat)) {
            return separatedFormat;
        }
        StringBuilder result = new StringBuilder(separatedFormat.length());
        int len = separatedFormat.length();
        for (int i = 0; i < len; ++i) {
            char ch = separatedFormat.charAt(i);
            if (separator == ch) {
                if (++i >= len) continue;
                result.append(Character.toUpperCase(separatedFormat.charAt(i)));
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static String requireNonBlank(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            throw new IllegalArgumentException("Text require non blank.");
        }
        return str;
    }

    public static String of(byte[] bytes, Charset charset) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, charset);
    }

    public static String concatSqlLike(String str) {
        if (StringUtils.isEmpty((CharSequence)str) || SQL_LIKE_LIST.contains(str)) {
            return str;
        }
        str = str.startsWith("^") ? str.substring(1) : "%" + str;
        str = str.endsWith("$") ? str.substring(0, str.length() - 1) : str + "%";
        return str;
    }

    public static String withSuffix(String str, String suffix) {
        if (str == null || str.isEmpty() || str.endsWith(suffix)) {
            return str;
        }
        return str + suffix;
    }

    public static String trimPath(String path) {
        if (StringUtils.isBlank((CharSequence)path) || "/".equals(path)) {
            return "/";
        }
        return (path = path.replaceAll("[/\\s]+$", "").trim()).startsWith("/") ? path : "/" + path;
    }

    public static String concatPath(String prefixPath, String suffixPath) {
        Assert.isTrue((boolean)prefixPath.startsWith("/"), (String)"Prefix path must start with '/'");
        if (prefixPath.length() > 1) {
            Assert.isTrue((!prefixPath.endsWith("/") ? 1 : 0) != 0, (String)"Prefix path cannot end with '/'");
        }
        Assert.isTrue((boolean)suffixPath.startsWith("/"), (String)"Suffix path must start with '/'");
        if (suffixPath.length() > 1) {
            Assert.isTrue((!suffixPath.endsWith("/") ? 1 : 0) != 0, (String)"Suffix path cannot end with '/'");
        }
        if ("/".equals(suffixPath)) {
            return prefixPath;
        }
        if ("/".equals(prefixPath)) {
            return suffixPath;
        }
        return prefixPath + suffixPath;
    }

    public static String substringAfterLast(String str, String separator) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        int lastIndexOf = str.lastIndexOf(separator);
        return lastIndexOf == -1 ? str : str.substring(lastIndexOf + 1);
    }
}

