/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.base;

import cn.ponfee.disjob.common.concurrent.Threads;
import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.common.util.UuidUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RetryTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(RetryTemplate.class);

    public static void execute(Throwables.ThrowingRunnable<Throwable> action, int retryMaxCount, long retryBackoffPeriod) throws Throwable {
        RetryTemplate.execute(action.toSupplier(null), retryMaxCount, retryBackoffPeriod);
    }

    public static <T> T execute(Throwables.ThrowingSupplier<T, Throwable> action, int retryMaxCount, long retryBackoffPeriod) throws Throwable {
        Assert.isTrue((retryMaxCount >= 0 ? 1 : 0) != 0, (String)"Retry max count cannot less than 0.");
        Assert.isTrue((retryBackoffPeriod > 0L ? 1 : 0) != 0, (String)"Retry backoff period must be greater than 0.");
        int i = 0;
        Throwable firstEx = null;
        String retryId = null;
        while (true) {
            try {
                return action.get();
            }
            catch (InterruptedException e) {
                LOG.error("Thread interrupted, abort retry.");
                throw e;
            }
            catch (Throwable e) {
                if (firstEx == null) {
                    firstEx = e;
                }
                if (i < retryMaxCount) {
                    if (retryId == null) {
                        retryId = UuidUtils.uuid32();
                    }
                    LOG.error("Execute failed, will retry: " + (i + 1) + ", " + retryId, e);
                    Thread.sleep((long)(i + 1) * retryBackoffPeriod);
                    continue;
                }
                LOG.error("Execute failed, exit retry: " + retryId, e);
                if (++i <= retryMaxCount) continue;
                throw firstEx;
            }
            break;
        }
    }

    public static void executeQuietly(Throwables.ThrowingRunnable<Throwable> action, int retryMaxCount, long retryBackoffPeriod) {
        RetryTemplate.executeQuietly(action.toSupplier(null), retryMaxCount, retryBackoffPeriod);
    }

    public static <T> T executeQuietly(Throwables.ThrowingSupplier<T, Throwable> action, int retryMaxCount, long retryBackoffPeriod) {
        try {
            return RetryTemplate.execute(action, retryMaxCount, retryBackoffPeriod);
        }
        catch (Throwable t) {
            Threads.interruptIfNecessary(t);
            return null;
        }
    }
}

