/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.collect;

import cn.ponfee.disjob.common.util.Numbers;
import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class Collects {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <E> LinkedList<E> newLinkedList(E element) {
        LinkedList<E> list = new LinkedList<E>();
        list.add(element);
        return list;
    }

    public static <E> ArrayDeque<E> newArrayDeque(E element) {
        ArrayDeque<E> list = new ArrayDeque<E>();
        list.add(element);
        return list;
    }

    public static <E> ArrayList<E> newArrayList(int initialCapacity, E element) {
        ArrayList<E> list = new ArrayList<E>(initialCapacity);
        list.add(element);
        return list;
    }

    public static <T> Set<T> truncate(Set<T> set, int length) {
        if (CollectionUtils.isEmpty(set) || length <= 0 || set.size() <= length) {
            return set;
        }
        HashSet<T> result = new HashSet<T>(length << 1);
        int i = 1;
        for (T t : set) {
            result.add(t);
            if (++i <= length) continue;
            break;
        }
        return result;
    }

    public static <T> List<T> duplicate(List<T> list) {
        return Collects.duplicate(list, Function.identity());
    }

    public static <R> List<R> split(String str, Function<String, R> converter) {
        return Collects.split(str, ",", converter);
    }

    public static <R> List<R> split(String str, String separator, Function<String, R> converter) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return Collections.emptyList();
        }
        return Arrays.stream(str.split(separator)).filter(StringUtils::isNotBlank).map(e -> converter.apply(e.trim())).distinct().collect(Collectors.toList());
    }

    public static <R> List<R> generate(int size, IntFunction<R> mapper) {
        return IntStream.range(0, size).mapToObj(mapper).collect(Collectors.toList());
    }

    public static <E, K> Map<K, E> toMap(List<E> list, Function<E, K> keyMapper) {
        return Collects.toMap(list, keyMapper, Function.identity());
    }

    public static <E, K, V> Map<K, V> toMap(List<E> list, Function<E, K> keyMapper, Function<E, V> valueMapper) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public static <T, R> List<R> duplicate(List<T> list, Function<T, R> mapper) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().map(mapper).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static <E> List<E> sorted(List<E> list, Comparator<? super E> comparator) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        Class<?> type = list.getClass();
        if (type == ArrayList.class || type == LinkedList.class) {
            list.sort(comparator);
            return list;
        }
        return list.stream().sorted(comparator).collect(Collectors.toList());
    }

    public static <T> T getFirst(Collection<T> coll) {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        if (coll instanceof Deque) {
            return (T)((Deque)coll).getFirst();
        }
        if (coll instanceof SortedSet) {
            return (T)((SortedSet)coll).first();
        }
        if (coll instanceof List) {
            return (T)((List)coll).get(0);
        }
        return coll.iterator().next();
    }

    public static <T> T getLast(Collection<T> coll) {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        if (coll instanceof Deque) {
            return (T)((Deque)coll).getLast();
        }
        if (coll instanceof SortedSet) {
            return (T)((SortedSet)coll).last();
        }
        if (coll instanceof List) {
            return (T)((List)coll).get(coll.size() - 1);
        }
        return coll.stream().reduce((a, b) -> b).orElse(null);
    }

    public static <T> T get(T[] array, int index) {
        if (array == null || index < 0 || index >= array.length) {
            return null;
        }
        return array[index];
    }

    public static <T> T get(List<T> list, int index) {
        if (list == null || index < 0 || index >= list.size()) {
            return null;
        }
        return list.get(index);
    }

    public static <T> void batchProcess(List<T> list, Consumer<List<T>> processor, int batchSize) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (list.size() <= batchSize) {
            processor.accept(list);
        } else {
            Lists.partition(list, (int)batchSize).forEach(processor);
        }
    }

    public static List<int[]> partition(int[] array, int size) {
        Assert.isTrue((size > 0 ? 1 : 0) != 0, (String)"Size must be greater than 0.");
        if (array == null || array.length == 0) {
            return null;
        }
        if ((size = Math.min(size, array.length)) == 1) {
            return Collections.singletonList(array);
        }
        ArrayList<int[]> result = new ArrayList<int[]>(size);
        int pos = 0;
        for (int number : Numbers.slice(array.length, size)) {
            if (number == 0) break;
            result.add(Arrays.copyOfRange(array, pos, pos += number));
        }
        return result;
    }

    public static <T> List<T> filter(List<T> list, Predicate<T> predicate) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return list.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <T> T findAny(Collection<T> coll, Predicate<T> predicate) {
        if (CollectionUtils.isEmpty(coll)) {
            return null;
        }
        return coll.stream().filter(predicate).findAny().orElse(null);
    }

    public static <S, T> List<T> convert(Collection<S> source, Function<S, T> mapper) {
        if (source == null) {
            return null;
        }
        if (source.isEmpty()) {
            return Collections.emptyList();
        }
        return source.stream().map(mapper).collect(Collectors.toList());
    }

    public static <S, T> Set<T> convert(Set<S> source, Function<S, T> mapper) {
        if (source == null) {
            return null;
        }
        if (source.isEmpty()) {
            return Collections.emptySet();
        }
        return source.stream().map(mapper).collect(Collectors.toSet());
    }

    @SafeVarargs
    public static <T> List<T> concat(List<T> list, T ... array) {
        if (list == null) {
            return array == null ? Collections.emptyList() : Arrays.asList(array);
        }
        if (array == null || array.length == 0) {
            return list;
        }
        ArrayList<T> result = new ArrayList<T>(list.size() + array.length);
        result.addAll(list);
        Collections.addAll(result, array);
        return result;
    }

    @SafeVarargs
    public static <T> T[] concat(T[] a1, T ... a2) {
        if (a1 == null || a1.length == 0) {
            return a2;
        }
        if (a2 == null || a2.length == 0) {
            return a1;
        }
        T[] result = Collects.newArray(a1.getClass(), a1.length + a2.length);
        System.arraycopy(a1, 0, result, 0, a1.length);
        try {
            System.arraycopy(a2, 0, result, a1.length, a2.length);
        }
        catch (ArrayStoreException e) {
            Class<?> t1 = a1.getClass().getComponentType();
            Class<?> t2 = a2.getClass().getComponentType();
            throw t1.isAssignableFrom(t2) ? e : new IllegalArgumentException("Cannot store " + t2.getName() + " into " + t1.getName() + "[]", e);
        }
        return result;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> concat(Map<K, V> ... maps) {
        return Arrays.stream(maps).flatMap(e -> e.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @SafeVarargs
    public static <T> ArrayList<T> asArrayList(T ... array) {
        ArrayList list = new ArrayList();
        if (array != null && array.length > 0) {
            Collections.addAll(list, array);
        }
        return list;
    }

    public static <T> List<T> drainAll(BlockingQueue<T> queue) {
        ArrayList list = new ArrayList(queue.size());
        queue.drainTo(list);
        return list;
    }

    public static <T> T[] newArray(Class<?> arrayType, int length) {
        return arrayType.equals(Object[].class) ? new Object[length] : (Object[])Array.newInstance(arrayType.getComponentType(), length);
    }
}

