/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.collect;

import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledObjectProcessor<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(PooledObjectProcessor.class);
    private final ConcurrentMap<K, SubPool> pool = new ConcurrentHashMap<K, SubPool>();
    private final int size;
    private final Function<K, V> creator;

    public PooledObjectProcessor(int size, Function<K, V> creator) {
        this.size = size;
        this.creator = creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R process(K key, Function<V, R> function) throws InterruptedException {
        SubPool subPool = this.pool.computeIfAbsent(key, x$0 -> new SubPool(x$0));
        Object value = subPool.borrowObject();
        try {
            R r = function.apply(value);
            return r;
        }
        finally {
            subPool.returnObject(value);
        }
    }

    private class SubPool {
        final K key;
        final BlockingQueue<V> queue;
        final AtomicInteger counter;

        SubPool(K key) {
            this.key = key;
            this.queue = new ArrayBlockingQueue(PooledObjectProcessor.this.size);
            this.counter = new AtomicInteger(PooledObjectProcessor.this.size);
        }

        V borrowObject() throws InterruptedException {
            Object value = this.queue.poll();
            if (value != null) {
                return value;
            }
            do {
                if (!this.requiredCreate()) continue;
                try {
                    value = PooledObjectProcessor.this.creator.apply(this.key);
                }
                catch (Throwable e) {
                    this.counter.incrementAndGet();
                    return ExceptionUtils.rethrow((Throwable)e);
                }
                if (value != null) {
                    LOG.debug("Created new object.");
                    return value;
                }
                this.counter.incrementAndGet();
                throw new NullPointerException("Created null object: " + this.key);
            } while ((value = this.queue.poll(200L, TimeUnit.MILLISECONDS)) == null);
            return value;
        }

        void returnObject(V value) throws InterruptedException {
            this.queue.put(Objects.requireNonNull(value));
        }

        boolean requiredCreate() {
            int count;
            while ((count = this.counter.get()) > 0) {
                if (!this.counter.compareAndSet(count, count - 1)) continue;
                return true;
            }
            return false;
        }
    }
}

