/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.collect;

import cn.ponfee.disjob.common.exception.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.util.Assert;

public class SynchronizedSegmentMap<K, V>
implements Map<K, V> {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private final Map<K, V>[] segments;
    private final int mask;
    private final int bits;
    private final int round;

    public SynchronizedSegmentMap() {
        this(16);
    }

    public SynchronizedSegmentMap(int buckets) {
        Assert.isTrue((1 < buckets && buckets <= 1024 ? 1 : 0) != 0, (String)"Segment buckets must be range (1, 1024]");
        this.segments = new Map[SynchronizedSegmentMap.segmentBucketsFor(buckets)];
        this.mask = this.segments.length - 1;
        this.bits = Integer.toBinaryString(this.mask).length();
        this.round = (32 + this.bits - 1) / this.bits;
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R, E extends Throwable> R process(K key, Throwables.ThrowingFunction<Map<K, V>, R, E> action) throws E {
        Map<K, V> map;
        Map<K, V> map2 = map = this.segmentAt(key);
        synchronized (map2) {
            return action.apply(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends Throwable> void execute(K key, Throwables.ThrowingConsumer<Map<K, V>, E> action) throws E {
        Map<K, V> map;
        Map<K, V> map2 = map = this.segmentAt(key);
        synchronized (map2) {
            action.accept(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E extends Throwable> void execute(Throwables.ThrowingConsumer<Map<K, V>, E> action) throws E {
        Map<K, V>[] mapArray = this.segments;
        int n = mapArray.length;
        for (int i = 0; i < n; ++i) {
            Map<K, V> map;
            Map<K, V> map2 = map = mapArray[i];
            synchronized (map2) {
                action.accept(map);
                continue;
            }
        }
    }

    @Override
    public V put(K key, V value) {
        return (V)this.process(key, e -> e.put(key, value));
    }

    @Override
    public V remove(Object key) {
        return (V)this.process(key, e -> e.remove(key));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        m.forEach((k, v) -> this.execute(k, e -> e.put(k, v)));
    }

    @Override
    public void clear() {
        this.execute(Map::clear);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (Map<? super K, ? super V> map : this.segments) {
            map.forEach(action);
        }
    }

    @Override
    public int size() {
        int res = 0;
        for (Map<K, V> map : this.segments) {
            res += map.size();
        }
        return res;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.segmentAt(key).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map<K, V> map : this.segments) {
            if (!map.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.segmentAt(key).get(key);
    }

    @Override
    public Set<K> keySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map<K, V> map : this.segments) {
            builder.addAll(map.keySet());
        }
        return builder.build();
    }

    @Override
    public Collection<V> values() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map<K, V> map : this.segments) {
            builder.addAll(map.values());
        }
        return builder.build();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map<K, V> map : this.segments) {
            builder.addAll(map.entrySet());
        }
        return builder.build();
    }

    private Map<K, V> segmentAt(Object key) {
        int index = key == null ? 0 : this.calculateIndex(key.hashCode());
        return this.segments[index];
    }

    private int calculateIndex(int n) {
        int r = n & this.mask;
        for (int i = 1; i < this.round; ++i) {
            r ^= n >>> i * this.bits & this.mask;
        }
        return r;
    }

    private static int segmentBucketsFor(int c) {
        int n = c - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }
}

