/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.collect;

import cn.ponfee.disjob.common.util.Numbers;
import java.util.Objects;
import java.util.function.Function;

public interface TypedDictionary<K, V> {
    public V get(Object var1);

    default public V put(K key, V value) {
        throw new UnsupportedOperationException("Cannot suppoerted put key value operation.");
    }

    default public V remove(Object key) {
        throw new UnsupportedOperationException("Cannot suppoerted remove key operation.");
    }

    default public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    default public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Cannot suppoerted contains value operation.");
    }

    default public V getRequired(K key) {
        return (V)this.getRequired(key, Function.identity());
    }

    default public V get(K key, V defaultVal) {
        V value = this.get(key);
        return value == null ? defaultVal : value;
    }

    default public String getRequiredString(K key) {
        return this.getRequired(key, Object::toString);
    }

    default public String getString(K key) {
        return this.getString(key, null);
    }

    default public String getString(K key, String defaultVal) {
        return Objects.toString(this.get(key), defaultVal);
    }

    default public String removeString(K key) {
        return this.removeString(key, null);
    }

    default public String removeString(K key, String defaultVal) {
        return Objects.toString(this.remove(key), defaultVal);
    }

    default public boolean getRequiredBoolean(K key) {
        V value = this.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null) {
            throw new IllegalArgumentException("Not presented value of '" + key + "'");
        }
        switch (value.toString()) {
            case "TRUE": 
            case "True": 
            case "true": {
                return true;
            }
            case "FALSE": 
            case "False": 
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid boolean value: " + value);
    }

    default public boolean getBoolean(K key, boolean defaultValue) {
        return Numbers.toBoolean(this.get(key), defaultValue);
    }

    default public Boolean getBoolean(K key) {
        return Numbers.toWrapBoolean(this.get(key));
    }

    default public boolean removeBoolean(K key, boolean defaultValue) {
        return Numbers.toBoolean(this.remove(key), defaultValue);
    }

    default public Boolean removeBoolean(K key) {
        return Numbers.toWrapBoolean(this.remove(key));
    }

    default public int getRequiredInt(K key) {
        return this.getRequired(key, Numbers::toInt);
    }

    default public int getInt(K key, int defaultValue) {
        return Numbers.toInt(this.get(key), defaultValue);
    }

    default public Integer getInt(K key) {
        return Numbers.toWrapInt(this.get(key));
    }

    default public int removeInt(K key, int defaultValue) {
        return Numbers.toInt(this.remove(key), defaultValue);
    }

    default public Integer removeInt(K key) {
        return Numbers.toWrapInt(this.remove(key));
    }

    default public long getRequiredLong(K key) {
        return this.getRequired(key, Numbers::toLong);
    }

    default public long getLong(K key, long defaultValue) {
        return Numbers.toLong(this.get(key), defaultValue);
    }

    default public Long getLong(K key) {
        return Numbers.toWrapLong(this.get(key));
    }

    default public long removeLong(K key, long defaultValue) {
        return Numbers.toLong(this.remove(key), defaultValue);
    }

    default public Long removeLong(K key) {
        return Numbers.toWrapLong(this.remove(key));
    }

    default public float getRequiredFloat(K key) {
        return this.getRequired(key, Numbers::toFloat).floatValue();
    }

    default public float getFloat(K key, float defaultValue) {
        return Numbers.toFloat(this.get(key), defaultValue);
    }

    default public Float getFloat(K key) {
        return Numbers.toWrapFloat(this.get(key));
    }

    default public float removeFloat(K key, float defaultValue) {
        return Numbers.toFloat(this.remove(key), defaultValue);
    }

    default public Float removeFloat(K key) {
        return Numbers.toWrapFloat(this.remove(key));
    }

    default public double getRequiredDouble(K key) {
        return this.getRequired(key, Numbers::toDouble);
    }

    default public double getDouble(K key, double defaultValue) {
        return Numbers.toDouble(this.get(key), defaultValue);
    }

    default public Double getDouble(K key) {
        return Numbers.toWrapDouble(this.get(key));
    }

    default public double removeDouble(K key, double defaultValue) {
        return Numbers.toDouble(this.remove(key), defaultValue);
    }

    default public Double removeDouble(K key) {
        return Numbers.toWrapDouble(this.remove(key));
    }

    default public <R> R getRequired(K key, Function<V, R> mapper) {
        V value = this.get(key);
        if (value == null) {
            throw new IllegalArgumentException("Not presented value of '" + key + "'");
        }
        return mapper.apply(value);
    }
}

