/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.concurrent;

import cn.ponfee.disjob.common.concurrent.LoggedUncaughtExceptionHandler;
import cn.ponfee.disjob.common.concurrent.Threads;
import cn.ponfee.disjob.common.concurrent.TripState;
import com.google.common.base.CaseFormat;
import java.io.Closeable;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHeartbeatThread
extends Thread
implements Closeable {
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final int MAX_PROCESSED_COUNT = 17;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TripState state = TripState.createStarted();
    protected final long heartbeatPeriodMs;

    protected AbstractHeartbeatThread(long heartbeatPeriodMs) {
        this.log.info("Heartbeat thread init.");
        this.heartbeatPeriodMs = Math.floorDiv(2L * heartbeatPeriodMs, 3L);
        super.setDaemon(true);
        super.setName(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.getClass().getSimpleName()) + "_thread");
        super.setPriority(10);
        super.setUncaughtExceptionHandler(new LoggedUncaughtExceptionHandler(this.log));
    }

    @Override
    public final void run() {
        this.log.info("Heartbeat thread started.");
        try {
            int processedCount = 0;
            while (this.state.isRunning()) {
                boolean isBusyLoop;
                if (super.isInterrupted()) {
                    this.log.error("Heartbeat interrupted state.");
                    break;
                }
                long begin = System.currentTimeMillis();
                try {
                    isBusyLoop = this.heartbeat();
                }
                catch (InterruptedException e) {
                    this.log.error("Heartbeat interrupted exception.", (Throwable)e);
                    break;
                }
                catch (Throwable t) {
                    isBusyLoop = true;
                    this.log.error("Heartbeat occur error: state=" + this.state, t);
                }
                long end = System.currentTimeMillis();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Heartbeat processed time: {}", (Object)(end - begin));
                }
                if (isBusyLoop) {
                    processedCount = 0;
                    this.doSleep(this.heartbeatPeriodMs + ThreadLocalRandom.current().nextLong(this.heartbeatPeriodMs));
                    continue;
                }
                if (++processedCount <= 17) continue;
                processedCount = 0;
                long sleepTime = end % 1000L;
                sleepTime = sleepTime != 0L ? sleepTime : 1000L;
                this.log.info("Max processed count, will sleep time milliseconds: {}", (Object)sleepTime);
                this.doSleep(sleepTime);
            }
        }
        catch (InterruptedException e) {
            this.log.warn("Heartbeat sleep interrupted: state={}, error={}", (Object)this.state, (Object)e.getMessage());
            Thread.currentThread().interrupt();
        }
        this.toStop();
        this.log.info("Heartbeat end.");
    }

    private void doSleep(long sleepTimeMillis) throws InterruptedException {
        Thread.sleep(sleepTimeMillis);
        this.log.debug("Heartbeat sleep time: {}", (Object)sleepTimeMillis);
    }

    public final boolean isStopped() {
        return Threads.isStopped(this);
    }

    @Override
    public void close() {
        this.doStop(2000L);
    }

    public boolean toStop() {
        return this.state.stop();
    }

    public void doStop(long joinMillis) {
        this.toStop();
        Threads.stopThread(this, joinMillis);
    }

    protected abstract boolean heartbeat() throws Exception;
}

