/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.concurrent;

import java.util.Objects;
import org.slf4j.Logger;

public final class LoggedUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Logger log;

    public LoggedUncaughtExceptionHandler(Logger log) {
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (e instanceof ThreadDeath) {
            this.log.warn("Uncaught exception handle, thread death: {}, {}", (Object)t.getName(), (Object)e.getMessage());
        } else if (e instanceof InterruptedException) {
            this.log.warn("Uncaught exception handle, thread interrupted: {}, {}", (Object)t.getName(), (Object)e.getMessage());
        } else {
            this.log.error("Uncaught exception handle, occur error: " + t.getName(), e);
        }
    }
}

