/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.concurrent;

import cn.ponfee.disjob.common.concurrent.LoggedUncaughtExceptionHandler;
import cn.ponfee.disjob.common.concurrent.TripState;
import cn.ponfee.disjob.common.exception.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(LoopThread.class);
    private final TripState state = TripState.create();
    private final long periodMs;
    private final long delayMs;
    private final Throwables.ThrowingRunnable<?> action;

    public LoopThread(String name, long periodMs, long delayMs, Throwables.ThrowingRunnable<?> action) {
        this(name, true, 10, periodMs, delayMs, action);
    }

    public LoopThread(String name, boolean daemon, int priority, long periodMs, long delayMs, Throwables.ThrowingRunnable<?> action) {
        super.setName(name);
        super.setDaemon(daemon);
        super.setPriority(priority);
        super.setUncaughtExceptionHandler(new LoggedUncaughtExceptionHandler(LOG));
        this.periodMs = periodMs;
        this.delayMs = delayMs;
        this.action = action;
    }

    public static LoopThread createStarted(String name, long periodMs, long delayMs, Throwables.ThrowingRunnable<?> action) {
        return LoopThread.createStarted(name, true, 10, periodMs, delayMs, action);
    }

    public static LoopThread createStarted(String name, boolean daemon, int priority, long periodMs, long delayMs, Throwables.ThrowingRunnable<?> action) {
        LoopThread thread = new LoopThread(name, daemon, priority, periodMs, delayMs, action);
        thread.start();
        return thread;
    }

    @Override
    public void run() {
        LOG.info("Loop process thread begin.");
        if (this.delayMs > 0L) {
            Throwables.ThrowingRunnable.doChecked(() -> Thread.sleep(this.delayMs));
        }
        while (this.state.isRunning()) {
            try {
                this.action.run();
                Thread.sleep(this.periodMs);
            }
            catch (InterruptedException e) {
                LOG.warn("Loop process thread interrupted {}: {}", (Object)super.getName(), (Object)e.getMessage());
                this.terminate();
                break;
            }
            catch (Throwable e) {
                LOG.error("Loop process thread error.", e);
            }
        }
        LOG.info("Loop process thread end.");
    }

    @Override
    public synchronized void start() {
        if (!this.state.start()) {
            throw new IllegalStateException("Loop process thread already started.");
        }
        super.start();
    }

    public boolean terminate() {
        if (this.state.stop()) {
            Throwables.ThrowingRunnable.doCaught(() -> super.interrupt());
            return true;
        }
        return false;
    }
}

