/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.concurrent;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MultithreadExecutors {
    public static <T> void run(Collection<T> coll, Consumer<T> action, Executor executor) {
        MultithreadExecutors.run(coll, action, executor, 2);
    }

    public static <T> void run(Collection<T> coll, Consumer<T> action, Executor executor, int dataSizeThreshold) {
        if (coll == null || coll.isEmpty()) {
            return;
        }
        if (dataSizeThreshold <= 0 || coll.size() < dataSizeThreshold) {
            coll.forEach(action);
            return;
        }
        coll.stream().map(e -> CompletableFuture.runAsync(() -> action.accept(e), executor)).collect(Collectors.toList()).forEach(CompletableFuture::join);
    }

    public static <T, U> List<U> call(Collection<T> coll, Function<T, U> mapper, Executor executor) {
        return MultithreadExecutors.call(coll, mapper, executor, 2);
    }

    public static <T, U> List<U> call(Collection<T> coll, Function<T, U> mapper, Executor executor, int dataSizeThreshold) {
        if (coll == null) {
            return null;
        }
        if (coll.isEmpty()) {
            return Collections.emptyList();
        }
        if (dataSizeThreshold <= 0 || coll.size() < dataSizeThreshold) {
            return coll.stream().map(mapper).collect(Collectors.toList());
        }
        return coll.stream().map(e -> CompletableFuture.supplyAsync(() -> mapper.apply(e), executor)).collect(Collectors.toList()).stream().map(CompletableFuture::join).collect(Collectors.toList());
    }
}

