/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.concurrent;

import cn.ponfee.disjob.common.exception.Throwables;
import java.util.Objects;
import java.util.concurrent.PriorityBlockingQueue;

public class ShutdownHookManager {
    private static volatile PriorityBlockingQueue<ShutdownTask> tasks;

    public static synchronized void addShutdownHook(int priority, Throwables.ThrowingRunnable<?> task) {
        ShutdownHookManager.init();
        tasks.add(new ShutdownTask(priority, task));
    }

    private static void init() {
        if (tasks == null) {
            tasks = new PriorityBlockingQueue();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                while (!tasks.isEmpty()) {
                    ShutdownTask task = tasks.poll();
                    if (task == null) continue;
                    task.run();
                }
            }));
        }
    }

    private static class ShutdownTask
    implements Comparable<ShutdownTask>,
    Runnable {
        private final int priority;
        private final Throwables.ThrowingRunnable<?> task;

        public ShutdownTask(int priority, Throwables.ThrowingRunnable<?> task) {
            this.priority = priority;
            this.task = Objects.requireNonNull(task);
        }

        @Override
        public int compareTo(ShutdownTask other) {
            return Integer.compare(this.priority, other.priority);
        }

        @Override
        public void run() {
            Throwables.ThrowingRunnable.doCaught(this.task, "Shutdown task execute failed: {}");
        }
    }
}

