/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.concurrent;

import cn.ponfee.disjob.common.concurrent.NamedThreadFactory;
import cn.ponfee.disjob.common.concurrent.ShutdownHookManager;
import cn.ponfee.disjob.common.concurrent.Threads;
import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.common.util.Numbers;
import cn.ponfee.disjob.common.util.SystemUtils;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public final class ThreadPoolExecutors {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolExecutors.class);
    public static final String DISJOB_COMMON_THREAD_POOL_SIZE = "disjob.common.thread.pool.size";
    public static final String DISJOB_COMMON_SCHEDULED_POOL_SIZE = "disjob.common.scheduled.pool.size";
    private static volatile ThreadPoolExecutor commonThreadPool;
    private static volatile ScheduledThreadPoolExecutor commonScheduledPool;
    public static final int MAX_CAP = Short.MAX_VALUE;
    public static final RejectedExecutionHandler ABORT;
    public static final RejectedExecutionHandler DISCARD;
    public static final RejectedExecutionHandler CALLER_RUNS;
    public static final RejectedExecutionHandler DISCARD_OLDEST;
    public static final RejectedExecutionHandler CALLER_RUNS_OLDEST;
    public static final RejectedExecutionHandler CALLER_BLOCKS;
    public static final RejectedExecutionHandler CALLER_RUNS_ANYWAY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolExecutor commonThreadPool() {
        if (commonThreadPool != null) return commonThreadPool;
        Class<ThreadPoolExecutors> clazz = ThreadPoolExecutors.class;
        synchronized (ThreadPoolExecutors.class) {
            if (commonThreadPool != null) return commonThreadPool;
            commonThreadPool = ThreadPoolExecutors.makeCommonThreadPoolExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return commonThreadPool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScheduledThreadPoolExecutor commonScheduledPool() {
        if (commonScheduledPool != null) return commonScheduledPool;
        Class<ThreadPoolExecutors> clazz = ThreadPoolExecutors.class;
        synchronized (ThreadPoolExecutors.class) {
            if (commonScheduledPool != null) return commonScheduledPool;
            commonScheduledPool = ThreadPoolExecutors.makeCommonScheduledPoolExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return commonScheduledPool;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static boolean shutdown(ExecutorService executorService) {
        try {
            executorService.shutdown();
            while (!executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
            }
            return true;
        }
        catch (Throwable t) {
            LOG.error("Shutdown ExecutorService occur error.", t);
            Throwables.ThrowingRunnable.doCaught(executorService::shutdownNow);
            Threads.interruptIfNecessary(t);
            return false;
        }
    }

    public static boolean shutdown(ExecutorService executorService, int awaitSeconds) {
        boolean isSafeTerminated = false;
        boolean hasCallShutdownNow = false;
        try {
            executorService.shutdown();
            isSafeTerminated = executorService.awaitTermination(awaitSeconds, TimeUnit.SECONDS);
            if (!isSafeTerminated) {
                hasCallShutdownNow = true;
                executorService.shutdownNow();
            }
        }
        catch (Throwable t) {
            LOG.error("Shutdown ExecutorService occur error.", t);
            if (!hasCallShutdownNow) {
                Throwables.ThrowingRunnable.doCaught(executorService::shutdownNow);
            }
            Threads.interruptIfNecessary(t);
        }
        return isSafeTerminated;
    }

    private static ThreadPoolExecutor makeCommonThreadPoolExecutor() {
        int poolSize = ThreadPoolExecutors.getCommonPoolSize(DISJOB_COMMON_THREAD_POOL_SIZE, 8);
        ThreadPoolExecutor threadPool = ThreadPoolExecutors.builder().corePoolSize(poolSize).maximumPoolSize(poolSize).workQueue(new ArrayBlockingQueue<Runnable>(poolSize * 20)).keepAliveTimeSeconds(600L).rejectedHandler(CALLER_RUNS).threadFactory(NamedThreadFactory.builder().prefix("disjob_common_thread_pool").priority(10).uncaughtExceptionHandler(LOG).build()).build();
        ShutdownHookManager.addShutdownHook(0, threadPool::shutdown);
        return threadPool;
    }

    private static ScheduledThreadPoolExecutor makeCommonScheduledPoolExecutor() {
        int poolSize = ThreadPoolExecutors.getCommonPoolSize(DISJOB_COMMON_SCHEDULED_POOL_SIZE, 16);
        ScheduledThreadPoolExecutor scheduledPool = new ScheduledThreadPoolExecutor(poolSize, NamedThreadFactory.builder().prefix("disjob_common_scheduled_pool").priority(10).uncaughtExceptionHandler(LOG).build(), CALLER_RUNS);
        scheduledPool.setRemoveOnCancelPolicy(true);
        ShutdownHookManager.addShutdownHook(0, scheduledPool::shutdown);
        return scheduledPool;
    }

    private static int getCommonPoolSize(String configKey, int minimumSize) {
        int poolSize = Numbers.toInt(SystemUtils.getConfig(configKey), Runtime.getRuntime().availableProcessors() * 2);
        if (poolSize < minimumSize || poolSize > Short.MAX_VALUE) {
            LOG.warn("Invalid configured disjob common pool size: {}", (Object)poolSize);
            poolSize = Numbers.bound(poolSize, minimumSize, Short.MAX_VALUE);
        }
        return poolSize;
    }

    static {
        ABORT = new ThreadPoolExecutor.AbortPolicy();
        DISCARD = new ThreadPoolExecutor.DiscardPolicy();
        CALLER_RUNS = new ThreadPoolExecutor.CallerRunsPolicy();
        DISCARD_OLDEST = new ThreadPoolExecutor.DiscardOldestPolicy();
        CALLER_RUNS_OLDEST = (currentTask, executor) -> {
            if (executor.isShutdown()) {
                return;
            }
            BlockingQueue<Runnable> workQueue = executor.getQueue();
            Runnable oldestTask = (Runnable)workQueue.poll();
            boolean state = workQueue.offer(currentTask);
            if (oldestTask != null) {
                oldestTask.run();
            }
            if (!state) {
                executor.execute(currentTask);
            }
        };
        CALLER_BLOCKS = (task, executor) -> {
            if (executor.isShutdown()) {
                return;
            }
            try {
                executor.getQueue().put(task);
            }
            catch (InterruptedException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        };
        CALLER_RUNS_ANYWAY = (task, executor) -> task.run();
    }

    public static class Builder {
        private int corePoolSize;
        private int maximumPoolSize;
        private BlockingQueue<Runnable> workQueue;
        private long keepAliveTimeSeconds = 0L;
        private RejectedExecutionHandler rejectedHandler;
        private ThreadFactory threadFactory;
        private boolean allowCoreThreadTimeOut = true;
        private PrestartCoreThreadType prestartCoreThreadType = PrestartCoreThreadType.NONE;

        private Builder() {
        }

        public Builder corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder maximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            return this;
        }

        public Builder workQueue(BlockingQueue<Runnable> workQueue) {
            this.workQueue = workQueue;
            return this;
        }

        public Builder keepAliveTimeSeconds(long keepAliveTimeSeconds) {
            this.keepAliveTimeSeconds = keepAliveTimeSeconds;
            return this;
        }

        public Builder rejectedHandler(RejectedExecutionHandler rejectedHandler) {
            this.rejectedHandler = rejectedHandler;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
            this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
            return this;
        }

        public Builder prestartCoreThreadType(PrestartCoreThreadType prestartCoreThreadType) {
            this.prestartCoreThreadType = prestartCoreThreadType;
            return this;
        }

        public ThreadPoolExecutor build() {
            Assert.isTrue((this.corePoolSize >= 0 ? 1 : 0) != 0, () -> String.format("Core pool size %d cannot less than 0.", this.corePoolSize));
            Assert.isTrue((this.corePoolSize <= this.maximumPoolSize ? 1 : 0) != 0, () -> String.format("Core pool size %d cannot greater than maximum pool size %d.", this.corePoolSize, this.maximumPoolSize));
            Assert.isTrue((this.maximumPoolSize <= Short.MAX_VALUE ? 1 : 0) != 0, () -> String.format("Maximum pool size %d cannot greater than %d.", this.maximumPoolSize, Short.MAX_VALUE));
            Assert.notNull(this.workQueue, (String)"Worker queue cannot be null.");
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTimeSeconds, TimeUnit.SECONDS, this.workQueue, this.threadFactory != null ? this.threadFactory : Executors.defaultThreadFactory(), this.rejectedHandler != null ? this.rejectedHandler : CALLER_RUNS);
            threadPoolExecutor.allowCoreThreadTimeOut(this.allowCoreThreadTimeOut);
            this.prestartCoreThreadType.prestart(threadPoolExecutor);
            return threadPoolExecutor;
        }
    }

    public static enum PrestartCoreThreadType {
        NONE{

            @Override
            public void prestart(ThreadPoolExecutor executor) {
            }
        }
        ,
        ONE{

            @Override
            public void prestart(ThreadPoolExecutor executor) {
                executor.prestartCoreThread();
            }
        }
        ,
        ALL{

            @Override
            public void prestart(ThreadPoolExecutor executor) {
                executor.prestartAllCoreThreads();
            }
        };


        public abstract void prestart(ThreadPoolExecutor var1);
    }
}

