/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.dag;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.common.dag.DAGNode;
import java.io.Serializable;
import java.util.Objects;

public final class DAGEdge
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 2292231888365728538L;
    private final DAGNode source;
    private final DAGNode target;

    public DAGEdge(DAGNode source, DAGNode target) {
        this.source = Objects.requireNonNull(source, "DAG source node cannot be null.");
        this.target = Objects.requireNonNull(target, "DAG target node cannot be null.");
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DAGEdge)) {
            return false;
        }
        DAGEdge that = (DAGEdge)obj;
        return this.source.equals(that.source) && this.target.equals(that.target);
    }

    @Override
    public String toString() {
        return "(" + this.source + " -> " + this.target + ")";
    }

    public DAGNode getSource() {
        return this.source;
    }

    public DAGNode getTarget() {
        return this.target;
    }
}

