/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.dag;

import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.dag.DAGEdge;
import cn.ponfee.disjob.common.dag.DAGNode;
import cn.ponfee.disjob.common.tree.PlainNode;
import cn.ponfee.disjob.common.tree.TreeNode;
import cn.ponfee.disjob.common.tuple.Tuple2;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.common.util.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.springframework.util.Assert;

public class DAGExpression {
    private static final Pattern JSON_ARRAY_PATTERN = Pattern.compile("(?s)^\\s*\\[\\s*\".+\"\\s*]\\s*$");
    private static final Pattern JSON_ITEM_PATTERN = Pattern.compile("^\\d+:\\d+:(\\s*\\S+\\s*)+$");
    private static final Pattern THUMB_SPLIT_PATTERN = Pattern.compile("(->)|(,)|(\\()|(\\))|(;)");
    private static final String SEP_TOPOLOGY = ";";
    private static final String SEP_STAGE = "->";
    private static final String SEP_UNION = ",";
    private static final List<String> SEP_SYMBOLS = ImmutableList.of((Object)"->", (Object)",");
    private static final List<String> ALL_SYMBOLS = ImmutableList.of((Object)"->", (Object)",", (Object)"(", (Object)")");
    private static final List<String> THUMB_SYMBOLS = ImmutableList.of((Object)"->", (Object)",", (Object)"(", (Object)")", (Object)";");
    private static final char[] SINGLE_SYMBOLS = new char[]{'(', ')', ','};
    private final String expression;
    private final Map<String, String> wrappedCache = new IdentityHashMap<String, String>();
    private final Map<PartitionIdentityKey, String> partitionCache = new HashMap<PartitionIdentityKey, String>();
    private final Map<String, List<Tuple2<String, Integer>>> incrementer = new HashMap<String, List<Tuple2<String, Integer>>>();

    public static Graph<DAGNode> parse(String expression) {
        return new DAGExpression(expression).parse();
    }

    public static String thumb(String expression) {
        List<DAGEdge> edges = DAGExpression.parseJsonArray(expression);
        return edges != null ? DAGExpression.thumbJsonExpr(edges) : DAGExpression.thumbPlainExpr(expression);
    }

    private DAGExpression(String expression) {
        Assert.hasText((String)expression, (String)"Expression cannot be blank.");
        this.expression = expression.trim();
    }

    private Graph<DAGNode> parse() {
        ImmutableGraph.Builder graphBuilder = GraphBuilder.directed().allowsSelfLoops(false).immutable();
        List<DAGEdge> edges = DAGExpression.parseJsonArray(this.expression);
        if (edges != null) {
            DAGExpression.parseJsonExpr((ImmutableGraph.Builder<DAGNode>)graphBuilder, edges);
        } else {
            this.parsePlainExpr((ImmutableGraph.Builder<DAGNode>)graphBuilder);
        }
        ImmutableGraph graph = graphBuilder.build();
        Assert.state((graph.nodes().size() > 2 ? 1 : 0) != 0, () -> "Expression not has node: " + this.expression);
        Assert.state((boolean)graph.successors((Object)DAGNode.START).stream().noneMatch(DAGNode::isEnd), () -> "Expression name cannot direct end: " + this.expression);
        Assert.state((boolean)graph.predecessors((Object)DAGNode.END).stream().noneMatch(DAGNode::isStart), () -> "Expression name cannot direct start: " + this.expression);
        Assert.state((!Graphs.hasCycle((Graph)graph) ? 1 : 0) != 0, () -> "Expression topology has cycle: " + this.expression);
        return graph;
    }

    private void parsePlainExpr(ImmutableGraph.Builder<DAGNode> graphBuilder) {
        Assert.isTrue((boolean)DAGExpression.checkParenthesis(this.expression), () -> "Invalid expression parenthesis parse: " + this.expression);
        List topologies = Stream.of(this.expression.split(SEP_TOPOLOGY)).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
        Assert.notEmpty(topologies, () -> "Invalid split with ';' expression: " + this.expression);
        int n = topologies.size();
        for (int i = 0; i < n; ++i) {
            String topology = (String)topologies.get(i);
            Assert.isTrue((boolean)DAGExpression.checkParenthesis(topology), () -> "Invalid expression parenthesis topology: " + topology);
            String expr = DAGExpression.completeParenthesis(topology);
            this.buildGraph(i + 1, Collections.singletonList(expr), graphBuilder, DAGNode.START, DAGNode.END);
        }
    }

    private void buildGraph(int topology, List<String> expressions, ImmutableGraph.Builder<DAGNode> graphBuilder, DAGNode prev, DAGNode next) {
        Tuple2<List<String>, List<String>> tuple = DAGExpression.divideFirstStage(expressions);
        if (tuple == null) {
            return;
        }
        List first = (List)tuple.a;
        List remains = (List)tuple.b;
        int n = first.size() - 1;
        for (int i = 0; i <= n; ++i) {
            List<String> list = this.resolve((String)first.get(i));
            Assert.notEmpty(list, () -> "Invalid expression build graph: " + String.join((CharSequence)"", expressions));
            if (list.size() == 1) {
                String name = list.get(0);
                DAGNode node = DAGNode.of(topology, this.incrementOrdinal(name), name);
                graphBuilder.putEdge((Object)prev, (Object)node);
                if (remains == null) {
                    graphBuilder.putEdge((Object)node, (Object)next);
                    continue;
                }
                this.buildGraph(topology, remains, graphBuilder, node, next);
                continue;
            }
            this.buildGraph(topology, DAGExpression.concat(list, remains), graphBuilder, prev, next);
        }
    }

    private List<String> resolve(String text) {
        String expr = text.trim();
        if (ALL_SYMBOLS.stream().noneMatch(expr::contains)) {
            return Collections.singletonList(expr);
        }
        if (!expr.startsWith("(") || !expr.endsWith(")")) {
            return this.resolve(this.wrappedCache.computeIfAbsent(expr, DAGExpression::wrap));
        }
        List<Tuple2<Integer, Integer>> groups = DAGExpression.group(expr);
        List outermost = groups.stream().filter(e -> (Integer)e.b == 1).collect(Collectors.toList());
        if (outermost.size() != 2) {
            if (outermost.size() > 2) {
                return this.resolve(this.wrappedCache.computeIfAbsent(expr, DAGExpression::wrap));
            }
            throw new IllegalArgumentException("Invalid expression outermost size: " + expr + ", " + outermost.size());
        }
        Assert.isTrue(((Integer)((Tuple2)outermost.get((int)0)).a == 0 && (Integer)((Tuple2)outermost.get((int)1)).a == expr.length() - 1 ? 1 : 0) != 0, () -> "Invalid expression: " + text);
        TreeNode<TreeNodeId, Object> root = DAGExpression.buildTree(groups);
        ArrayList<Integer> list = new ArrayList<Integer>(root.getNodeDegree() * 2 + 2);
        list.add(((TreeNodeId)root.getId()).open);
        root.forEachChild(child -> {
            list.add(((TreeNodeId)child.getId()).open);
            list.add(((TreeNodeId)child.getId()).close);
        });
        list.add(((TreeNodeId)root.getId()).close);
        return this.partition(expr, list);
    }

    private List<String> partition(String expr, List<Integer> groups) {
        ArrayList<String> result = new ArrayList<String>(groups.size());
        int n = groups.size() - 1;
        for (int i = 0; i < n; ++i) {
            PartitionIdentityKey key = new PartitionIdentityKey(expr, groups.get(i) + 1, groups.get(i + 1));
            Strings.applyIfNotBlank(this.partitionCache.computeIfAbsent(key, rec$ -> ((PartitionIdentityKey)rec$).partition()), result::add);
        }
        return result;
    }

    private int incrementOrdinal(String name) {
        List list = this.incrementer.computeIfAbsent(name, k -> new LinkedList());
        Tuple2<String, Integer> tuple = list.stream().filter(e -> name == e.a).findAny().orElse(null);
        if (tuple == null) {
            tuple = Tuple2.of(name, list.size() + 1);
            list.add(tuple);
        }
        return (Integer)tuple.b;
    }

    private static List<DAGEdge> parseJsonArray(String json) {
        if (!JSON_ARRAY_PATTERN.matcher(json).matches()) {
            return null;
        }
        try {
            List<String> list = Jsons.fromJson(json, Jsons.LIST_STRING);
            if (CollectionUtils.isEmpty(list)) {
                return null;
            }
            ArrayList<DAGEdge> edges = new ArrayList<DAGEdge>(list.size());
            for (String item : list) {
                String[] array = item.split(SEP_STAGE);
                Assert.isTrue((array.length == 2 ? 1 : 0) != 0, () -> "Invalid json graph item: " + item);
                DAGNode source = DAGExpression.processJsonItem(array[0].trim());
                DAGNode target = DAGExpression.processJsonItem(array[1].trim());
                edges.add(new DAGEdge(source, target));
            }
            return edges;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static DAGNode processJsonItem(String item) {
        Assert.hasText((String)item, (String)"Json array item cannot be blank.");
        if (!JSON_ITEM_PATTERN.matcher(item).matches()) {
            item = "1:1:" + item;
        }
        return DAGNode.fromString(item);
    }

    private static void parseJsonExpr(ImmutableGraph.Builder<DAGNode> graphBuilder, List<DAGEdge> edges) {
        Assert.notEmpty(edges, (String)"Graph edges cannot be empty.");
        HashSet<DAGNode> allNode = new HashSet<DAGNode>();
        HashSet<DAGNode> nonHead = new HashSet<DAGNode>();
        HashSet<DAGNode> nonTail = new HashSet<DAGNode>();
        for (DAGEdge edge : edges) {
            DAGNode source = edge.getSource();
            DAGNode target = edge.getTarget();
            Assert.isTrue((!source.isStartOrEnd() ? 1 : 0) != 0, () -> "Graph edge cannot be start or end: " + source);
            Assert.isTrue((!target.isStartOrEnd() ? 1 : 0) != 0, () -> "Graph edge cannot be start or end: " + target);
            graphBuilder.putEdge((Object)source, (Object)target);
            allNode.add(source);
            allNode.add(target);
            nonHead.add(target);
            nonTail.add(source);
        }
        allNode.stream().filter(e -> !nonHead.contains(e)).forEach(e -> graphBuilder.putEdge((Object)DAGNode.START, e));
        allNode.stream().filter(e -> !nonTail.contains(e)).forEach(e -> graphBuilder.putEdge(e, (Object)DAGNode.END));
    }

    private static Tuple2<List<String>, List<String>> divideFirstStage(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (SEP_SYMBOLS.contains(Collects.getFirst(list)) || SEP_SYMBOLS.contains(Collects.getLast(list))) {
            throw new IllegalArgumentException("Invalid expression divide stage: " + String.join((CharSequence)"", list));
        }
        if (list.size() == 1) {
            return Tuple2.of(list, null);
        }
        ArrayList<String> head = new ArrayList<String>(list.size());
        int i = 0;
        int n = list.size() - 1;
        block8: while (i <= n) {
            head.add(list.get(i++));
            if (i > n) {
                return Tuple2.of(head, null);
            }
            switch (list.get(i++)) {
                case "->": {
                    return Tuple2.of(head, list.subList(i, list.size()));
                }
                case ",": {
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Invalid expression separator: " + String.join((CharSequence)"", list));
        }
        return Tuple2.of(head, null);
    }

    private static TreeNode<TreeNodeId, Object> buildTree(List<Tuple2<Integer, Integer>> groups) {
        ArrayList<PlainNode<TreeNodeId, Object>> nodes = new ArrayList<PlainNode<TreeNodeId, Object>>(groups.size() + 1);
        DAGExpression.buildNodes(nodes, groups, null, 1, 0);
        return TreeNode.build(nodes);
    }

    private static void buildNodes(List<PlainNode<TreeNodeId, Object>> nodes, List<Tuple2<Integer, Integer>> groups, TreeNodeId parentId, int level, int start) {
        int open = -1;
        int n = groups.size();
        for (int i = start; i < n; ++i) {
            if ((Integer)groups.get((int)i).b < level) {
                return;
            }
            if ((Integer)groups.get((int)i).b != level) continue;
            if (open == -1) {
                open = i;
                continue;
            }
            TreeNodeId id = new TreeNodeId((Integer)groups.get((int)open).a, (Integer)groups.get((int)i).a);
            nodes.add(new PlainNode(id, parentId));
            DAGExpression.buildNodes(nodes, groups, id, level + 1, open + 1);
            open = -1;
        }
    }

    private static List<String> concat(List<String> sources, List<String> targets) {
        if (CollectionUtils.isEmpty(targets)) {
            return sources;
        }
        ArrayList<String> result = new ArrayList<String>(sources.size() + 1 + targets.size());
        result.addAll(sources);
        result.add(SEP_STAGE);
        result.addAll(targets);
        return result;
    }

    private static boolean checkParenthesis(String text) {
        int openCount = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            char c = text.charAt(i);
            if (c == '(') {
                ++openCount;
            } else if (c == ')') {
                --openCount;
            }
            if (openCount >= 0) continue;
            return false;
        }
        return openCount == 0;
    }

    private static String completeParenthesis(String text) {
        ArrayList<String> list = new ArrayList<String>();
        int mark = 0;
        int position = 0;
        int len = text.length() - 1;
        while (position <= len) {
            char ch;
            if (ArrayUtils.contains((char[])SINGLE_SYMBOLS, (char)(ch = text.charAt(position++)))) {
                list.add(text.substring(mark, position - 1).trim());
                list.add(Character.toString(ch));
                mark = position;
                continue;
            }
            if (ch != '-' || position > len || text.charAt(position) != '>') continue;
            list.add(text.substring(mark, position - 1).trim());
            list.add(SEP_STAGE);
            mark = ++position;
        }
        if (position > mark) {
            list.add(text.substring(mark, position).trim());
        }
        StringBuilder builder = new StringBuilder();
        int n = list.size() - 1;
        for (int i = 0; i <= n; ++i) {
            String item = (String)list.get(i);
            if (StringUtils.isBlank((CharSequence)item)) continue;
            if (ALL_SYMBOLS.contains(item)) {
                builder.append(item);
                continue;
            }
            if ("(".equals(Collects.get(list, i - 1)) && ")".equals(Collects.get(list, i + 1))) {
                builder.append(item);
                continue;
            }
            builder.append("(").append(item).append(")");
        }
        return builder.toString();
    }

    private static List<Tuple2<Integer, Integer>> group(String expr) {
        Assert.isTrue((boolean)DAGExpression.checkParenthesis(expr), () -> "Invalid expression parenthesis group: " + expr);
        int depth = 0;
        ArrayList<Tuple2<Integer, Integer>> list = new ArrayList<Tuple2<Integer, Integer>>();
        int n = expr.length();
        for (int i = 0; i < n; ++i) {
            if (expr.charAt(i) == '(') {
                if (++depth > 2) continue;
                list.add(Tuple2.of(i, depth));
                continue;
            }
            if (expr.charAt(i) != ')') continue;
            if (depth <= 2) {
                list.add(Tuple2.of(i, depth));
            }
            --depth;
        }
        Assert.isTrue((list.size() % 2 == 0 ? 1 : 0) != 0, () -> "Expression not pair with '()': " + expr);
        return list;
    }

    private static String wrap(String text) {
        return "(" + text + ")";
    }

    private static String thumbJsonExpr(List<DAGEdge> edges) {
        MutableInt begin = new MutableInt(65);
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<DAGEdge> list = new ArrayList<DAGEdge>(edges.size());
        for (DAGEdge edge : edges) {
            DAGNode source = edge.getSource();
            String sourceThumb = map.computeIfAbsent(source.getName(), k -> String.valueOf((char)begin.getAndIncrement()));
            DAGNode target = edge.getTarget();
            String targetThumb = map.computeIfAbsent(target.getName(), k -> String.valueOf((char)begin.getAndIncrement()));
            list.add(new DAGEdge(DAGNode.of(source.getTopology(), source.getOrdinal(), sourceThumb), DAGNode.of(target.getTopology(), target.getOrdinal(), targetThumb)));
        }
        return Jsons.toJson(list.stream().map(e -> e.getSource() + " -> " + e.getTarget()).toArray());
    }

    private static String thumbPlainExpr(String expression) {
        MutableInt begin = new MutableInt(65);
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        for (String str : DAGExpression.splitPlainExpr(expression)) {
            if (THUMB_SYMBOLS.contains(str)) {
                builder.append(str);
                continue;
            }
            builder.append(map.computeIfAbsent(str, k -> String.valueOf((char)begin.getAndIncrement())));
        }
        return builder.toString();
    }

    private static List<String> splitPlainExpr(String expression) {
        Matcher matcher = THUMB_SPLIT_PATTERN.matcher(expression);
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        while (matcher.find()) {
            Strings.applyIfNotBlank(expression.substring(start, matcher.start()), list::add);
            Strings.applyIfNotBlank(matcher.group(), list::add);
            start = matcher.end();
        }
        Strings.applyIfNotBlank(expression.substring(start), list::add);
        return list;
    }

    private static final class PartitionIdentityKey {
        private final String expr;
        private final int open;
        private final int close;

        private PartitionIdentityKey(String expr, int open, int close) {
            Assert.hasText((String)expr, () -> "Partition expression cannot be blank: " + expr);
            Assert.isTrue((open >= 0 ? 1 : 0) != 0, () -> "Partition open must be >= 0: " + open);
            Assert.isTrue((close >= open ? 1 : 0) != 0, () -> "Partition close must be >= open: " + close + ", " + open);
            this.expr = expr;
            this.open = open;
            this.close = close;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PartitionIdentityKey)) {
                return false;
            }
            PartitionIdentityKey that = (PartitionIdentityKey)obj;
            return this.expr == that.expr && this.open == that.open && this.close == that.close;
        }

        public int hashCode() {
            return System.identityHashCode(this.expr) + this.open + this.close;
        }

        private String partition() {
            return this.expr.substring(this.open, this.close).trim();
        }
    }

    private static final class TreeNodeId
    implements Serializable,
    Comparable<TreeNodeId> {
        private static final long serialVersionUID = -468548698179536500L;
        private final int open;
        private final int close;

        private TreeNodeId(int open, int close) {
            Assert.isTrue((open >= 0 ? 1 : 0) != 0, () -> "Tree node id open must be >= 0: " + open);
            Assert.isTrue((close > open ? 1 : 0) != 0, () -> "Tree node id close must be > open: " + close + ", " + open);
            this.open = open;
            this.close = close;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TreeNodeId)) {
                return false;
            }
            TreeNodeId that = (TreeNodeId)obj;
            return this.open == that.open && this.close == that.close;
        }

        public int hashCode() {
            return this.open + this.close;
        }

        @Override
        public int compareTo(TreeNodeId that) {
            int n = this.open - that.open;
            return n != 0 ? n : this.close - that.close;
        }

        public String toString() {
            return "(" + this.open + DAGExpression.SEP_UNION + this.close + ")";
        }
    }
}

