/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.dag;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.util.Assert;

public final class DAGNode
implements Serializable {
    private static final long serialVersionUID = 7413110685194391605L;
    public static final DAGNode START = new DAGNode(0, 0, "Start");
    public static final DAGNode END = new DAGNode(0, 0, "End");
    private final int topology;
    private final int ordinal;
    private final String name;

    private DAGNode(int topology, int ordinal, String name) {
        this.topology = topology;
        this.ordinal = ordinal;
        this.name = name;
    }

    public static DAGNode of(int topology, int ordinal, String name) {
        Assert.isTrue((topology > 0 ? 1 : 0) != 0, () -> "Topology must be greater than 0: " + topology);
        Assert.isTrue((ordinal > 0 ? 1 : 0) != 0, () -> "Ordinal must be greater than 0: " + ordinal);
        Assert.hasText((String)name, () -> "Name cannot be blank: " + name);
        return new DAGNode(topology, ordinal, name.trim());
    }

    @Transient
    public boolean isStart() {
        return this.equals(START);
    }

    @Transient
    public boolean isEnd() {
        return this.equals(END);
    }

    @Transient
    public boolean isStartOrEnd() {
        return this.isStart() || this.isEnd();
    }

    public int hashCode() {
        return Objects.hash(this.topology, this.ordinal, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DAGNode)) {
            return false;
        }
        DAGNode that = (DAGNode)obj;
        return this.topology == that.topology && this.ordinal == that.ordinal && this.name.equals(that.name);
    }

    public String toString() {
        return this.topology + ":" + this.ordinal + ":" + this.name;
    }

    public boolean equals(int topology, int ordinal, String name) {
        return this.topology == topology && this.ordinal == ordinal && this.name.equals(name);
    }

    public static DAGNode fromString(String str) {
        Assert.hasText((String)str, (String)"DAG node text cannot be blank.");
        String[] array = str.trim().split(":", 3);
        int topology = Integer.parseInt(array[0]);
        int ordinal = Integer.parseInt(array[1]);
        String name = array[2].trim();
        if (START.equals(topology, ordinal, name)) {
            return START;
        }
        if (END.equals(topology, ordinal, name)) {
            return END;
        }
        return DAGNode.of(topology, ordinal, name);
    }

    public int getTopology() {
        return this.topology;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }
}

