/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.date;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class Dates {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATEFULL_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_TO_STRING_PATTERN = "EEE MMM dd HH:mm:ss zzz yyyy";
    public static final FastDateFormat DATETIME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");

    public static boolean isValidDate(String dateStr, String pattern) {
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return false;
        }
        try {
            new SimpleDateFormat(pattern).parse(dateStr);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static Date now() {
        return new Date();
    }

    public static String now(String pattern) {
        return Dates.format(Dates.now(), pattern);
    }

    public static Date toDate(String dateStr, String pattern) {
        try {
            return new SimpleDateFormat(pattern).parse(dateStr);
        }
        catch (ParseException e) {
            return (Date)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static Date ofTimeMillis(long timeMillis) {
        return new Date(timeMillis);
    }

    public static Date ofTimeMillis(Long timeMillis) {
        return timeMillis == null ? null : new Date(timeMillis);
    }

    public static long currentUnixTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static Date ofUnixTimestamp(long unixTimestamp) {
        return new Date(unixTimestamp * 1000L);
    }

    public static Date ofUnixTimestamp(Long unixTimestamp) {
        return unixTimestamp == null ? null : new Date(unixTimestamp * 1000L);
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String format(Date date) {
        if (date == null) {
            return null;
        }
        return DATETIME_FORMAT.format(date);
    }

    public static String format(long timeMillis, String pattern) {
        return Dates.format(new Date(timeMillis), pattern);
    }

    public static String formatDuration(long durationMillis) {
        if (durationMillis < 1000000L) {
            return Dates.formatDouble((double)durationMillis / 1000.0) + "s";
        }
        if (durationMillis < 60000000L) {
            return Dates.formatDouble((double)durationMillis / 60000.0) + "m";
        }
        if (durationMillis < 3600000000L) {
            return Dates.formatDouble((double)durationMillis / 3600000.0) + "h";
        }
        if (durationMillis < 86400000000L) {
            return Dates.formatDouble((double)durationMillis / 8.64E7) + "d";
        }
        return durationMillis / 86400000L + "d";
    }

    public static Date plusMillis(Date date, long millis) {
        return new Date(date.getTime() + millis);
    }

    public static Date plusSeconds(Date date, long seconds) {
        return Dates.plusMillis(date, seconds * 1000L);
    }

    public static Date plusMinutes(Date date, long minutes) {
        return Dates.plusMillis(date, minutes * 60L * 1000L);
    }

    public static Date plusHours(Date date, long hours) {
        return Dates.plusMillis(date, hours * 60L * 60L * 1000L);
    }

    public static Date plusDays(Date date, long days) {
        return Dates.plusMillis(date, days * 24L * 60L * 60L * 1000L);
    }

    public static Date plusWeeks(Date date, long weeks) {
        return Dates.plusMillis(date, weeks * 7L * 24L * 60L * 60L * 1000L);
    }

    public static Date plusMonths(Date date, long months) {
        return Dates.toDate(Dates.toLocalDateTime(date).plusMonths(months));
    }

    public static Date plusYears(Date date, long years) {
        return Dates.toDate(Dates.toLocalDateTime(date).plusYears(years));
    }

    public static Date minusMillis(Date date, long millis) {
        return Dates.plusMillis(date, -millis);
    }

    public static Date minusSeconds(Date date, long seconds) {
        return Dates.plusSeconds(date, -seconds);
    }

    public static Date minusMinutes(Date date, long minutes) {
        return Dates.plusMinutes(date, -minutes);
    }

    public static Date minusHours(Date date, long hours) {
        return Dates.plusHours(date, -hours);
    }

    public static Date minusDays(Date date, long days) {
        return Dates.plusDays(date, -days);
    }

    public static Date minusWeeks(Date date, long weeks) {
        return Dates.plusWeeks(date, -weeks);
    }

    public static Date minusMonths(Date date, long months) {
        return Dates.toDate(Dates.toLocalDateTime(date).minusMonths(months));
    }

    public static Date minusYears(Date date, long years) {
        return Dates.toDate(Dates.toLocalDateTime(date).minusYears(years));
    }

    public static Date startOfDay(Date date) {
        return Dates.toDate(Dates.startOfDay0(date));
    }

    public static Date endOfDay(Date date) {
        return Dates.toDate(Dates.endOfDay0(date));
    }

    public static Date startOfWeek(Date date) {
        return Dates.toDate(Dates.startOfDay0(date).with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)));
    }

    public static Date endOfWeek(Date date) {
        return Dates.toDate(Dates.endOfDay0(date).with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY)));
    }

    public static Date startOfMonth(Date date) {
        return Dates.toDate(Dates.startOfDay0(date).with(TemporalAdjusters.firstDayOfMonth()));
    }

    public static Date endOfMonth(Date date) {
        return Dates.toDate(Dates.endOfDay0(date).with(TemporalAdjusters.lastDayOfMonth()));
    }

    public static Date startOfYear(Date date) {
        return Dates.toDate(Dates.startOfDay0(date).with(TemporalAdjusters.firstDayOfYear()));
    }

    public static Date endOfYear(Date date) {
        return Dates.toDate(Dates.endOfDay0(date).with(TemporalAdjusters.lastDayOfYear()));
    }

    public static Date withDayOfWeek(Date date, int dayOfWeek) {
        LocalDateTime dateTime = Dates.toLocalDateTime(date).with(WeekFields.of(DayOfWeek.MONDAY, 1).dayOfWeek(), dayOfWeek);
        return Dates.toDate(dateTime);
    }

    public static Date withDayOfMonth(Date date, int dayOfMonth) {
        return Dates.toDate(Dates.toLocalDateTime(date).withDayOfMonth(dayOfMonth));
    }

    public static Date withDayOfYear(Date date, int dayOfYear) {
        return Dates.toDate(Dates.toLocalDateTime(date).withDayOfYear(dayOfYear));
    }

    public static int dayOfYear(Date date) {
        return Dates.toLocalDateTime(date).getDayOfYear();
    }

    public static int dayOfMonth(Date date) {
        return Dates.toLocalDateTime(date).getDayOfMonth();
    }

    public static int dayOfWeek(Date date) {
        return Dates.toLocalDateTime(date).getDayOfWeek().getValue();
    }

    public static int hourOfDay(Date date) {
        return Dates.toLocalDateTime(date).getHour();
    }

    public static long clockDiff(Date start, Date end) {
        return (end.getTime() - start.getTime()) / 1000L;
    }

    public static int daysBetween(Date start, Date end) {
        return (int)(Dates.toLocalDate(end).toEpochDay() - Dates.toLocalDate(start).toEpochDay());
    }

    public static Date random(Date begin, Date end) {
        long endMills;
        long beginMills = begin.getTime();
        if (beginMills >= (endMills = end.getTime())) {
            throw new IllegalArgumentException("Date [" + Dates.format(begin) + "] must before [" + Dates.format(end) + "]");
        }
        return Dates.random(beginMills, endMills);
    }

    public static Date random(long beginTimeMills, long endTimeMills) {
        if (beginTimeMills >= endTimeMills) {
            throw new IllegalArgumentException("Date [" + beginTimeMills + "] must before [" + endTimeMills + "]");
        }
        return new Date(beginTimeMills + ThreadLocalRandom.current().nextLong(endTimeMills - beginTimeMills));
    }

    public static Date min(Date a, Date b) {
        if (a == null) {
            return b;
        }
        return b == null || a.before(b) ? a : b;
    }

    public static Date max(Date a, Date b) {
        if (a == null) {
            return b;
        }
        return b == null || a.after(b) ? a : b;
    }

    public static Date max(Date a, Date b, Date c) {
        return Dates.max(Dates.max(a, b), c);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date toDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime startOfDay(LocalDateTime dateTime) {
        return LocalDateTime.of(dateTime.toLocalDate(), LocalTime.MIN);
    }

    public static LocalDateTime endOfDay(LocalDateTime dateTime) {
        return LocalDateTime.of(dateTime.toLocalDate(), LocalTime.of(23, 59, 59, 0));
    }

    public static Date zoneConvert(Date date, ZoneId sourceZone, ZoneId targetZone) {
        if (date == null || sourceZone.equals(targetZone)) {
            return date;
        }
        return Date.from(date.toInstant().atZone(targetZone).withZoneSameLocal(sourceZone).toInstant());
    }

    public static LocalDateTime zoneConvert(LocalDateTime localDateTime, ZoneId sourceZone, ZoneId targetZone) {
        if (localDateTime == null || sourceZone.equals(targetZone)) {
            return localDateTime;
        }
        return ZonedDateTime.of(localDateTime, sourceZone).withZoneSameInstant(targetZone).toLocalDateTime();
    }

    public static String toCronExpression(Date date) {
        return Dates.toCronExpression(Dates.toLocalDateTime(date));
    }

    public static String toCronExpression(LocalDateTime dateTime) {
        return new StringBuilder(22).append(dateTime.getSecond()).append(' ').append(dateTime.getMinute()).append(' ').append(dateTime.getHour()).append(' ').append(dateTime.getDayOfMonth()).append(' ').append(dateTime.getMonthValue()).append(' ').append('?').append(' ').append(dateTime.getYear()).toString();
    }

    private static String formatDouble(double value) {
        return BigDecimal.valueOf(value).setScale(3, RoundingMode.DOWN).toString().substring(0, 5);
    }

    private static LocalDateTime startOfDay0(Date date) {
        return Dates.startOfDay(Dates.toLocalDateTime(date));
    }

    private static LocalDateTime endOfDay0(Date date) {
        return Dates.endOfDay(Dates.toLocalDateTime(date));
    }
}

