/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.exception;

import cn.ponfee.disjob.common.concurrent.Threads;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Throwables {
    private static final Logger LOG = LoggerFactory.getLogger(Throwables.class);
    private static final Supplier<String> EMPTY_MESSAGE = () -> "";

    public static String getRootCauseStackTrace(Throwable t, int maxLength) {
        if (t == null) {
            return null;
        }
        Throwable root = ExceptionUtils.getRootCause((Throwable)t);
        if (root == null) {
            root = t;
        }
        return StringUtils.truncate((String)ExceptionUtils.getStackTrace((Throwable)root), (int)maxLength);
    }

    public static String getRootCauseMessage(Throwable t) {
        if (t == null) {
            return null;
        }
        List list = ExceptionUtils.getThrowableList((Throwable)t);
        for (int i = list.size() - 1; i >= 0; --i) {
            String message = ((Throwable)list.get(i)).getMessage();
            if (!StringUtils.isNotBlank((CharSequence)message)) continue;
            return message;
        }
        return "error@" + ClassUtils.getName(t.getClass());
    }

    @FunctionalInterface
    public static interface ThrowingFunction<E, R, T extends Throwable> {
        public R apply(E var1) throws T;

        default public ThrowingConsumer<E, T> toConsumer() {
            return this::apply;
        }

        public static <E, R> R doChecked(ThrowingFunction<E, R, ?> function, E arg) {
            try {
                return function.apply(arg);
            }
            catch (Throwable t) {
                return (R)ExceptionUtils.rethrow((Throwable)t);
            }
        }

        public static <E, R> R doCaught(ThrowingFunction<E, R, ?> function, E arg) {
            return ThrowingFunction.doCaught(function, arg, null, EMPTY_MESSAGE);
        }

        public static <E, R> R doCaught(ThrowingFunction<E, R, ?> function, E arg, R defaultValue, Supplier<String> message) {
            try {
                return function.apply(arg);
            }
            catch (Throwable t) {
                LOG.error(message.get(), t);
                Threads.interruptIfNecessary(t);
                return defaultValue;
            }
        }

        public static <E, R> Function<E, R> toChecked(ThrowingFunction<E, R, ?> function) {
            return e -> {
                try {
                    return function.apply(e);
                }
                catch (Throwable t) {
                    return ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }

        public static <E, R> Function<E, R> toCaught(ThrowingFunction<E, R, ?> function) {
            return ThrowingFunction.toCaught(function, null, EMPTY_MESSAGE);
        }

        public static <E, R> Function<E, R> toCaught(ThrowingFunction<E, R, ?> function, R defaultValue, Supplier<String> message) {
            return arg -> {
                try {
                    return function.apply(arg);
                }
                catch (Throwable t) {
                    LOG.error((String)message.get(), t);
                    Threads.interruptIfNecessary(t);
                    return defaultValue;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<E, T extends Throwable> {
        public void accept(E var1) throws T;

        default public <R> ThrowingFunction<E, R, T> toFunction(R result) {
            return x -> {
                this.accept(x);
                return result;
            };
        }

        public static <E> void doChecked(ThrowingConsumer<E, ?> consumer, E arg) {
            try {
                consumer.accept(arg);
            }
            catch (Throwable t) {
                ExceptionUtils.rethrow((Throwable)t);
            }
        }

        public static <E> void doCaught(ThrowingConsumer<E, ?> consumer, E arg) {
            ThrowingConsumer.doCaught(consumer, arg, EMPTY_MESSAGE);
        }

        public static <E> void doCaught(ThrowingConsumer<E, ?> consumer, E arg, Supplier<String> message) {
            try {
                consumer.accept(arg);
            }
            catch (Throwable t) {
                LOG.error(message.get(), t);
                Threads.interruptIfNecessary(t);
            }
        }

        public static <E> Consumer<E> toChecked(ThrowingConsumer<E, ?> consumer) {
            return e -> {
                try {
                    consumer.accept(e);
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }

        public static <E> Consumer<E> toCaught(ThrowingConsumer<E, ?> consumer) {
            return ThrowingConsumer.toCaught(consumer, EMPTY_MESSAGE);
        }

        public static <E> Consumer<E> toCaught(ThrowingConsumer<E, ?> consumer, Supplier<String> message) {
            return arg -> {
                try {
                    consumer.accept(arg);
                }
                catch (Throwable t) {
                    LOG.error((String)message.get(), t);
                    Threads.interruptIfNecessary(t);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingCallable<R, T extends Throwable> {
        public R call() throws T;

        default public ThrowingRunnable<T> toRunnable() {
            return this::call;
        }

        public static <R> R doChecked(ThrowingCallable<R, ?> callable) {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                return (R)ExceptionUtils.rethrow((Throwable)t);
            }
        }

        public static <R> R doCaught(ThrowingCallable<R, ?> callable) {
            return ThrowingCallable.doCaught(callable, null, EMPTY_MESSAGE);
        }

        public static <R> R doCaught(ThrowingCallable<R, ?> callable, R defaultValue, Supplier<String> message) {
            try {
                return callable.call();
            }
            catch (Throwable t) {
                LOG.error(message.get(), t);
                Threads.interruptIfNecessary(t);
                return defaultValue;
            }
        }

        public static <R> Callable<R> toChecked(ThrowingCallable<R, ?> callable) {
            return () -> {
                try {
                    return callable.call();
                }
                catch (Throwable t) {
                    return ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }

        public static <R> Callable<R> toCaught(ThrowingCallable<R, ?> supplier) {
            return ThrowingCallable.toCaught(supplier, null, EMPTY_MESSAGE);
        }

        public static <R> Callable<R> toCaught(ThrowingCallable<R, ?> supplier, R defaultValue, Supplier<String> message) {
            return () -> {
                try {
                    return supplier.call();
                }
                catch (Throwable t) {
                    LOG.error((String)message.get(), t);
                    Threads.interruptIfNecessary(t);
                    return defaultValue;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<R, T extends Throwable> {
        public R get() throws T;

        default public ThrowingRunnable<Throwable> toRunnable() {
            return this::get;
        }

        public static <R> R doChecked(ThrowingSupplier<R, ?> supplier) {
            try {
                return supplier.get();
            }
            catch (Throwable t) {
                return (R)ExceptionUtils.rethrow((Throwable)t);
            }
        }

        public static <R> R doCaught(ThrowingSupplier<R, ?> supplier) {
            return ThrowingSupplier.doCaught(supplier, null, EMPTY_MESSAGE);
        }

        public static <R> R doCaught(ThrowingSupplier<R, ?> supplier, R defaultValue, Supplier<String> message) {
            try {
                return supplier.get();
            }
            catch (Throwable t) {
                LOG.error(message.get(), t);
                Threads.interruptIfNecessary(t);
                return defaultValue;
            }
        }

        public static <R> Supplier<R> toChecked(ThrowingSupplier<R, ?> supplier) {
            return () -> {
                try {
                    return supplier.get();
                }
                catch (Throwable t) {
                    return ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }

        public static <R> Supplier<R> toCaught(ThrowingSupplier<R, ?> supplier) {
            return ThrowingSupplier.toCaught(supplier, null, EMPTY_MESSAGE);
        }

        public static <R> Supplier<R> toCaught(ThrowingSupplier<R, ?> supplier, R defaultValue, Supplier<String> message) {
            return () -> {
                try {
                    return supplier.get();
                }
                catch (Throwable t) {
                    LOG.error((String)message.get(), t);
                    Threads.interruptIfNecessary(t);
                    return defaultValue;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingRunnable<T extends Throwable> {
        public void run() throws T;

        default public <R> ThrowingSupplier<R, T> toSupplier(R result) {
            return () -> {
                this.run();
                return result;
            };
        }

        default public <R> ThrowingCallable<R, T> toCallable(R result) {
            return () -> {
                this.run();
                return result;
            };
        }

        public static void doChecked(ThrowingRunnable<?> runnable) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                ExceptionUtils.rethrow((Throwable)t);
            }
        }

        public static void doCaught(ThrowingRunnable<?> runnable) {
            ThrowingRunnable.doCaught(runnable, EMPTY_MESSAGE);
        }

        public static void doCaught(ThrowingRunnable<?> runnable, String message) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOG.error(message, (Object)t.getMessage());
                Threads.interruptIfNecessary(t);
            }
        }

        public static void doCaught(ThrowingRunnable<?> runnable, Supplier<String> message) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                LOG.error(message.get(), t);
                Threads.interruptIfNecessary(t);
            }
        }

        public static Runnable toChecked(ThrowingRunnable<?> runnable) {
            return () -> {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrow((Throwable)t);
                }
            };
        }

        public static Runnable toCaught(ThrowingRunnable<?> runnable) {
            return ThrowingRunnable.toCaught(runnable, EMPTY_MESSAGE);
        }

        public static Runnable toCaught(ThrowingRunnable<?> runnable, Supplier<String> message) {
            return () -> {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    LOG.error((String)message.get(), t);
                    Threads.interruptIfNecessary(t);
                }
            };
        }
    }
}

