/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.lock;

import cn.ponfee.disjob.common.lock.LockTemplate;
import cn.ponfee.disjob.common.lock.RedisLock;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLockTemplate
implements LockTemplate {
    private static final Logger LOG = LoggerFactory.getLogger(RedisLockTemplate.class);
    private final RedisLock redisLock;

    public RedisLockTemplate(RedisLock redisLock) {
        this.redisLock = redisLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(Callable<T> action) {
        if (this.redisLock.tryLock()) {
            try {
                T t = action.call();
                return t;
            }
            catch (Throwable t) {
                LOG.error("Executed in redis lock occur error.", t);
                T t2 = null;
                return t2;
            }
            finally {
                this.redisLock.unlock();
            }
        }
        return null;
    }
}

