/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.model;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.model.PageResponse;
import java.beans.Transient;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToLongFunction;

public class PageRequest
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 2032344850017264330L;
    private boolean paged = true;
    private int pageNumber;
    private int pageSize;
    private String sort;

    @Transient
    public long getOffset() {
        return (long)(this.pageNumber - 1) * (long)this.pageSize;
    }

    public <P extends PageRequest, A> PageResponse<A> query(ToLongFunction<P> queryCount, Function<P, List<A>> queryRecord) {
        return this.query(queryCount, queryRecord, null);
    }

    public <P extends PageRequest, A, B> PageResponse<B> query(ToLongFunction<P> queryCount, Function<P, List<A>> queryRecords, Function<A, B> mapper) {
        List<Object> list;
        long total;
        this.check();
        PageRequest this0 = this;
        if (this.paged) {
            total = queryCount.applyAsLong(this0);
            this.correctPageNumber(total);
            list = total == 0L ? Collections.emptyList() : queryRecords.apply(this0);
        } else {
            list = queryRecords.apply(this0);
            total = list.size();
        }
        List<A> rows = mapper == null ? list : Collects.convert(list, mapper);
        return PageResponse.of(rows, total, this0);
    }

    private void check() {
        int minPageSize;
        int n = minPageSize = this.paged ? 1 : 0;
        if (this.pageSize < minPageSize) {
            throw new IllegalArgumentException("Invalid page size value [" + this.pageSize + "].");
        }
    }

    private void correctPageNumber(long total) {
        this.pageNumber = this.pageNumber < 1 || total == 0L ? 1 : Math.min(this.pageNumber, PageResponse.computeTotalPages(this.pageSize, total));
    }

    public boolean isPaged() {
        return this.paged;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getSort() {
        return this.sort;
    }

    public void setPaged(boolean paged) {
        this.paged = paged;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }
}

