/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.model;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.common.model.PageRequest;
import java.beans.Transient;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class PageResponse<T>
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 3175875483341043538L;
    private List<T> rows;
    private long total;
    private PageRequest request;

    @Transient
    public int getTotalPages() {
        return PageResponse.computeTotalPages(this.request.getPageSize(), this.total);
    }

    public boolean hasPrevious() {
        return this.request.isPaged() && this.request.getPageNumber() > 1 && this.getTotalPages() > 1;
    }

    public boolean hasNext() {
        return this.request.isPaged() && this.request.getPageNumber() < this.getTotalPages();
    }

    @Transient
    public boolean isFirst() {
        return !this.hasPrevious();
    }

    @Transient
    public boolean isLast() {
        return !this.hasNext();
    }

    public void forEachRow(Consumer<T> action) {
        if (this.rows != null) {
            this.rows.forEach(action);
        }
    }

    public static int computeTotalPages(int pageSize, long total) {
        return (int)((total + (long)pageSize - 1L) / (long)pageSize);
    }

    public static <T> PageResponse<T> empty() {
        return PageResponse.of(Collections.emptyList(), 0L, null);
    }

    public static <T> PageResponse<T> of(List<T> rows, long total) {
        return PageResponse.of(rows, total, null);
    }

    public static <T> PageResponse<T> of(List<T> rows, long total, PageRequest request) {
        PageResponse<T> response = new PageResponse<T>();
        response.setRows(rows);
        response.setTotal(total);
        response.setRequest(request);
        return response;
    }

    public List<T> getRows() {
        return this.rows;
    }

    public long getTotal() {
        return this.total;
    }

    public PageRequest getRequest() {
        return this.request;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setRequest(PageRequest request) {
        this.request = request;
    }
}

