/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.collect.TypedDictionary;
import cn.ponfee.disjob.common.date.JavaUtilDateFormat;
import cn.ponfee.disjob.common.date.LocalDateTimeFormat;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class BaseController
implements TypedDictionary<String, String> {
    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                try {
                    super.setValue(JavaUtilDateFormat.DEFAULT.parse(text));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Invalid date format: " + text);
                }
            }
        });
        binder.registerCustomEditor(LocalDateTime.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                super.setValue(LocalDateTimeFormat.DEFAULT.parse(text));
            }
        });
        binder.registerCustomEditor(LocalDate.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                LocalDateTime dateTime = LocalDateTimeFormat.DEFAULT.parse(text);
                super.setValue(dateTime == null ? null : dateTime.toLocalDate());
            }
        });
        binder.registerCustomEditor(LocalTime.class, (PropertyEditor)new PropertyEditorSupport(){
            private final DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");

            @Override
            public void setAsText(String text) {
                super.setValue(LocalTime.parse(text, this.timeFormatter));
            }
        });
    }

    public static ServletRequestAttributes getRequestAttributes() {
        return (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
    }

    public static HttpServletRequest getRequest() {
        return BaseController.getRequestAttributes().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return BaseController.getRequestAttributes().getResponse();
    }

    public static HttpSession getSession() {
        return BaseController.getRequest().getSession();
    }

    @Override
    public String get(Object key) {
        return BaseController.getRequest().getParameter(key == null ? null : key.toString());
    }

    @Override
    public boolean containsKey(Object key) {
        return BaseController.getRequest().getParameterMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return BaseController.getRequest().getParameterMap().containsValue(value);
    }
}

