/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.base.RetryTemplate;
import cn.ponfee.disjob.common.exception.Throwables;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class JdbcTemplateWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcTemplateWrapper.class);
    public static final RowMapper<String> STRING_ROW_MAPPER = new SingleColumnRowMapper(String.class);
    public static final RowMapper<Long> LONG_ROW_MAPPER = new SingleColumnRowMapper(Long.class);
    public static final RowMapper<Integer> INTEGER_ROW_MAPPER = new SingleColumnRowMapper(Integer.class);
    private static final ConcurrentMap<String, Boolean> EXISTS_TABLE = new ConcurrentHashMap<String, Boolean>();
    private final JdbcTemplate jdbcTemplate;

    private JdbcTemplateWrapper(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public static JdbcTemplateWrapper of(JdbcTemplate jdbcTemplate) {
        return new JdbcTemplateWrapper(jdbcTemplate);
    }

    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    public int insert(String sql, Object ... args) {
        Assert.isTrue((boolean)sql.startsWith("INSERT "), () -> "Invalid INSERT sql: " + sql);
        return this.jdbcTemplate.update(sql, args);
    }

    public int update(String sql, Object ... args) {
        Assert.isTrue((boolean)sql.startsWith("UPDATE "), () -> "Invalid UPDATE sql: " + sql);
        return this.jdbcTemplate.update(sql, args);
    }

    public int delete(String sql, Object ... args) {
        Assert.isTrue((boolean)sql.startsWith("DELETE "), () -> "Invalid DELETE sql: " + sql);
        return this.jdbcTemplate.update(sql, args);
    }

    public <T> List<T> list(String sql, RowMapper<T> rowMapper, Object ... args) {
        Assert.isTrue((boolean)sql.startsWith("SELECT "), () -> "Invalid LIST sql: " + sql);
        return this.jdbcTemplate.query(sql, rowMapper, args);
    }

    public <T> T get(String sql, RowMapper<T> rowMapper, Object ... args) {
        Assert.isTrue((boolean)sql.startsWith("SELECT "), () -> "Invalid GET sql: " + sql);
        List result = this.jdbcTemplate.query(sql, rowMapper, args);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return null;
        }
        if (result.size() == 1) {
            return (T)result.get(0);
        }
        throw new IncorrectResultSizeDataAccessException(1, result.size());
    }

    public void executeInTransaction(Throwables.ThrowingConsumer<Throwables.ThrowingFunction<String, PreparedStatement, ?>, ?> action) {
        this.executeInTransaction(action.toFunction(null));
    }

    public <T> T executeInTransaction(Throwables.ThrowingFunction<Throwables.ThrowingFunction<String, PreparedStatement, ?>, T, ?> action) {
        return (T)this.jdbcTemplate.execute(con -> {
            PreparedStatementCreator psCreator = null;
            boolean originalAutoCommit = con.getAutoCommit();
            try {
                if (originalAutoCommit) {
                    con.setAutoCommit(false);
                }
                psCreator = new PreparedStatementCreator(con);
                Object result = action.apply(psCreator);
                con.commit();
                Object r = result;
                return r;
            }
            catch (Throwable t) {
                Throwables.ThrowingRunnable.doCaught(con::rollback, "Connection rollback occur error: {}");
                Object object = ExceptionUtils.rethrow((Throwable)t);
                return object;
            }
            finally {
                if (originalAutoCommit) {
                    Throwables.ThrowingRunnable.doCaught(() -> con.setAutoCommit(true), "Restore auto-commit occur error: {}");
                }
                if (psCreator != null) {
                    psCreator.close();
                }
            }
        });
    }

    public void createTableIfNotExists(String tableName, String createTableDdl) {
        EXISTS_TABLE.computeIfAbsent(tableName.trim().toLowerCase(), key -> {
            try {
                return RetryTemplate.execute(() -> {
                    if (this.existsTable((String)key)) {
                        return true;
                    }
                    this.jdbcTemplate.execute(createTableDdl);
                    Assert.state((boolean)this.existsTable((String)key), () -> "Create table " + key + " failed.");
                    LOG.info("Created table {} success.", key);
                    return true;
                }, 3, 1000L);
            }
            catch (Throwable e) {
                return (Boolean)ExceptionUtils.rethrow((Throwable)e);
            }
        });
    }

    public boolean existsTable(String tableName) {
        Boolean result = (Boolean)this.jdbcTemplate.execute(conn -> {
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getTables(null, null, tableName, new String[]{"TABLE"});
            boolean exists = rs.next() && tableName.equalsIgnoreCase(rs.getString(3));
            JdbcUtils.closeResultSet((ResultSet)rs);
            return exists;
        });
        return Boolean.TRUE.equals(result);
    }

    private static class PreparedStatementCreator
    implements Throwables.ThrowingFunction<String, PreparedStatement, Throwable> {
        private final Connection con;
        private final List<PreparedStatement> psList = new LinkedList<PreparedStatement>();

        private PreparedStatementCreator(Connection con) {
            this.con = con;
        }

        @Override
        public PreparedStatement apply(String sql) throws Throwable {
            PreparedStatement ps = this.con.prepareStatement(sql);
            this.psList.add(ps);
            return ps;
        }

        public void close() {
            Lists.reverse(this.psList).forEach(JdbcUtils::closeStatement);
        }
    }
}

