/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.exception.Throwables;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.SocketOptions;
import io.lettuce.core.TimeoutOptions;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.ClusterTopologyRefreshOptions;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.resource.DefaultClientResources;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;

public class RedisTemplateFactory
implements Closeable {
    private final RedisProperties properties;
    private final ClientResources clientResources;
    private final LettuceConnectionFactory redisConnectionFactory;
    private final RedisTemplate<Object, Object> redisTemplate;
    private final StringRedisTemplate stringRedisTemplate;

    public RedisTemplateFactory(RedisProperties properties) {
        this(properties, (ClientResources)DefaultClientResources.builder().build(), null);
    }

    public RedisTemplateFactory(RedisProperties properties, ClientResources clientResources, ObjectProvider<LettuceClientConfigurationBuilderCustomizer> builderCustomizers) {
        if (properties.getClientType() != null && properties.getClientType() != RedisProperties.ClientType.LETTUCE) {
            throw new IllegalArgumentException("Unsupported redis client type: " + properties.getClientType());
        }
        this.properties = Objects.requireNonNull(properties);
        this.clientResources = Objects.requireNonNull(clientResources);
        this.redisConnectionFactory = this.createConnectionFactory(builderCustomizers);
        this.redisTemplate = RedisTemplateFactory.createRedisTemplate((RedisConnectionFactory)this.redisConnectionFactory);
        this.stringRedisTemplate = new StringRedisTemplate((RedisConnectionFactory)this.redisConnectionFactory);
    }

    public LettuceConnectionFactory getRedisConnectionFactory() {
        return this.redisConnectionFactory;
    }

    public RedisTemplate<Object, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    @Override
    public void close() {
        Throwables.ThrowingRunnable.doCaught(() -> Thread.sleep(3000L));
        Throwables.ThrowingRunnable.doCaught(() -> ((LettuceConnectionFactory)this.redisConnectionFactory).destroy());
        Throwables.ThrowingRunnable.doCaught(() -> ((ClientResources)this.clientResources).shutdown());
    }

    private LettuceConnectionFactory createConnectionFactory(ObjectProvider<LettuceClientConfigurationBuilderCustomizer> builderCustomizers) {
        RedisClusterConfiguration clusterConfiguration;
        LettuceClientConfiguration.LettuceClientConfigurationBuilder builder = this.createBuilder();
        builder.clientOptions(this.createClientOptions());
        builder.clientResources(this.clientResources);
        if (builderCustomizers != null) {
            builderCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
        }
        LettuceClientConfiguration clientConfiguration = builder.build();
        RedisSentinelConfiguration sentinelConfiguration = this.getSentinelConfiguration();
        LettuceConnectionFactory connectionFactory = sentinelConfiguration != null ? new LettuceConnectionFactory(sentinelConfiguration, clientConfiguration) : ((clusterConfiguration = this.getClusterConfiguration()) != null ? new LettuceConnectionFactory(clusterConfiguration, clientConfiguration) : new LettuceConnectionFactory(this.getStandaloneConfiguration(), clientConfiguration));
        connectionFactory.afterPropertiesSet();
        return connectionFactory;
    }

    private LettuceClientConfiguration.LettuceClientConfigurationBuilder createBuilder() {
        String url;
        RedisProperties.Lettuce lettuce;
        LettuceClientConfiguration.LettuceClientConfigurationBuilder builder;
        RedisProperties.Pool pool = this.properties.getLettuce().getPool();
        if (Boolean.FALSE.equals(pool.getEnabled())) {
            builder = LettuceClientConfiguration.builder();
        } else {
            GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
            poolConfig.setMaxTotal(pool.getMaxActive());
            poolConfig.setMaxIdle(pool.getMaxIdle());
            poolConfig.setMinIdle(pool.getMinIdle());
            if (pool.getTimeBetweenEvictionRuns() != null) {
                poolConfig.setTimeBetweenEvictionRuns(pool.getTimeBetweenEvictionRuns());
            }
            if (pool.getMaxWait() != null) {
                poolConfig.setMaxWait(pool.getMaxWait());
            }
            builder = LettucePoolingClientConfiguration.builder().poolConfig(poolConfig);
        }
        if (this.properties.isSsl()) {
            builder.useSsl();
        }
        if (this.properties.getTimeout() != null) {
            builder.commandTimeout(this.properties.getTimeout());
        }
        if (this.properties.getLettuce() != null && (lettuce = this.properties.getLettuce()).getShutdownTimeout() != null && !lettuce.getShutdownTimeout().isZero()) {
            builder.shutdownTimeout(this.properties.getLettuce().getShutdownTimeout());
        }
        if (StringUtils.hasText((String)this.properties.getClientName())) {
            builder.clientName(this.properties.getClientName());
        }
        if (StringUtils.hasText((String)(url = this.properties.getUrl())) && RedisTemplateFactory.parseUrl(url).isUseSsl()) {
            builder.useSsl();
        }
        return builder;
    }

    private ClientOptions createClientOptions() {
        ClientOptions.Builder clientOptionsBuilder;
        if (this.properties.getCluster() == null) {
            clientOptionsBuilder = ClientOptions.builder();
        } else {
            RedisProperties.Lettuce.Cluster.Refresh refreshProperties = this.properties.getLettuce().getCluster().getRefresh();
            ClusterTopologyRefreshOptions.Builder refreshBuilder = ClusterTopologyRefreshOptions.builder().dynamicRefreshSources(refreshProperties.isDynamicRefreshSources());
            if (refreshProperties.getPeriod() != null) {
                refreshBuilder.enablePeriodicRefresh(refreshProperties.getPeriod());
            }
            if (refreshProperties.isAdaptive()) {
                refreshBuilder.enableAllAdaptiveRefreshTriggers();
            }
            clientOptionsBuilder = ClusterClientOptions.builder().topologyRefreshOptions(refreshBuilder.build());
        }
        Duration connectTimeout = this.properties.getConnectTimeout();
        if (connectTimeout != null) {
            clientOptionsBuilder.socketOptions(SocketOptions.builder().connectTimeout(connectTimeout).build());
        }
        return clientOptionsBuilder.timeoutOptions(TimeoutOptions.enabled()).build();
    }

    private RedisSentinelConfiguration getSentinelConfiguration() {
        RedisProperties.Sentinel sentinelProperties = this.properties.getSentinel();
        if (sentinelProperties == null) {
            return null;
        }
        RedisSentinelConfiguration config = new RedisSentinelConfiguration();
        config.master(sentinelProperties.getMaster());
        config.setSentinels(RedisTemplateFactory.createSentinels(sentinelProperties));
        config.setUsername(this.properties.getUsername());
        if (this.properties.getPassword() != null) {
            config.setPassword(RedisPassword.of((String)this.properties.getPassword()));
        }
        config.setSentinelUsername(sentinelProperties.getUsername());
        if (sentinelProperties.getPassword() != null) {
            config.setSentinelPassword(RedisPassword.of((String)sentinelProperties.getPassword()));
        }
        config.setDatabase(this.properties.getDatabase());
        return config;
    }

    private RedisClusterConfiguration getClusterConfiguration() {
        RedisProperties.Cluster clusterProperties = this.properties.getCluster();
        if (clusterProperties == null) {
            return null;
        }
        RedisClusterConfiguration config = new RedisClusterConfiguration((Collection)clusterProperties.getNodes());
        if (clusterProperties.getMaxRedirects() != null) {
            config.setMaxRedirects(clusterProperties.getMaxRedirects().intValue());
        }
        config.setUsername(this.properties.getUsername());
        if (this.properties.getPassword() != null) {
            config.setPassword(RedisPassword.of((String)this.properties.getPassword()));
        }
        return config;
    }

    private RedisStandaloneConfiguration getStandaloneConfiguration() {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        if (StringUtils.hasText((String)this.properties.getUrl())) {
            UrlInfo urlInfo = RedisTemplateFactory.parseUrl(this.properties.getUrl());
            config.setHostName(urlInfo.getHostName());
            config.setPort(urlInfo.getPort());
            config.setUsername(urlInfo.getUsername());
            config.setPassword(RedisPassword.of((String)urlInfo.getPassword()));
        } else {
            config.setHostName(this.properties.getHost());
            config.setPort(this.properties.getPort());
            config.setUsername(this.properties.getUsername());
            config.setPassword(RedisPassword.of((String)this.properties.getPassword()));
        }
        config.setDatabase(this.properties.getDatabase());
        return config;
    }

    private static RedisTemplate<Object, Object> createRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    private static UrlInfo parseUrl(String url) {
        Object[] schemes = new String[]{"redis", "rediss"};
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            if (!ArrayUtils.contains((Object[])schemes, (Object)scheme)) {
                throw new UnsupportedOperationException(url);
            }
            boolean useSsl = ((String)schemes[1]).equals(scheme);
            String username = null;
            String password = null;
            if (uri.getUserInfo() != null) {
                String candidate = uri.getUserInfo();
                int index = candidate.indexOf(58);
                if (index >= 0) {
                    username = candidate.substring(0, index);
                    password = candidate.substring(index + 1);
                } else {
                    password = candidate;
                }
            }
            return new UrlInfo(uri, useSsl, username, password);
        }
        catch (URISyntaxException ex) {
            throw new UnsupportedOperationException(url, ex);
        }
    }

    private static List<RedisNode> createSentinels(RedisProperties.Sentinel sentinel) {
        ArrayList<RedisNode> nodes = new ArrayList<RedisNode>(sentinel.getNodes().size());
        for (String node : sentinel.getNodes()) {
            try {
                nodes.add(RedisNode.fromString((String)node));
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException("Invalid redis sentinel property '" + node + "'", ex);
            }
        }
        return nodes;
    }

    private static class UrlInfo {
        private final URI uri;
        private final boolean useSsl;
        private final String username;
        private final String password;

        UrlInfo(URI uri, boolean useSsl, String username, String password) {
            this.uri = uri;
            this.useSsl = useSsl;
            this.username = username;
            this.password = password;
        }

        String getHostName() {
            return this.uri.getHost();
        }

        int getPort() {
            return this.uri.getPort();
        }

        public URI getUri() {
            return this.uri;
        }

        public boolean isUseSsl() {
            return this.useSsl;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

