/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.exception.Throwables;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

public class RedisTemplateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RedisTemplateUtils.class);

    public static <T> T evalScript(RedisTemplate<?, ?> redisTemplate, RedisScript<T> script, byte[][] keys, byte[] ... args) {
        int numKeys = keys == null ? 0 : keys.length;
        return RedisTemplateUtils.evalScript(redisTemplate, script, numKeys, (byte[][])Collects.concat(keys, args));
    }

    public static <T> T evalScript(RedisTemplate<?, ?> redisTemplate, RedisScript<T> script, int numKeys, byte[][] keysAndArgs) {
        ReturnType returnType = ReturnType.fromJavaType((Class)script.getResultType());
        return (T)redisTemplate.execute(conn -> {
            if (conn.isPipelined() || conn.isQueueing()) {
                conn.eval(script.getScriptAsString().getBytes(StandardCharsets.UTF_8), returnType, numKeys, keysAndArgs);
                return null;
            }
            try {
                return conn.evalSha(script.getSha1(), returnType, numKeys, keysAndArgs);
            }
            catch (Exception e) {
                if (RedisTemplateUtils.exceptionContainsNoScriptError(e)) {
                    LOG.info(e.getMessage());
                    return conn.eval(script.getScriptAsString().getBytes(StandardCharsets.UTF_8), returnType, numKeys, keysAndArgs);
                }
                return ExceptionUtils.rethrow((Throwable)e);
            }
        });
    }

    public static RedisMessageListenerContainer createRedisMessageListenerContainer(StringRedisTemplate redisTemplate, String channelTopicName, Executor taskExecutor, Object delegateObject, String listenerMethodName) {
        Throwables.ThrowingSupplier.doChecked(() -> delegateObject.getClass().getMethod(listenerMethodName, String.class, String.class));
        MessageListenerAdapter listenerAdapter = new MessageListenerAdapter(delegateObject, listenerMethodName);
        listenerAdapter.afterPropertiesSet();
        return RedisTemplateUtils.createRedisMessageListenerContainer(redisTemplate, channelTopicName, taskExecutor, listenerAdapter);
    }

    public static RedisMessageListenerContainer createRedisMessageListenerContainer(StringRedisTemplate redisTemplate, String channelTopicName, Executor taskExecutor, MessageListenerAdapter listenerAdapter) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(Objects.requireNonNull(redisTemplate.getConnectionFactory()));
        container.setTaskExecutor(taskExecutor);
        container.addMessageListener((MessageListener)listenerAdapter, (Topic)new ChannelTopic(channelTopicName));
        container.afterPropertiesSet();
        container.start();
        return container;
    }

    private static boolean exceptionContainsNoScriptError(Throwable t) {
        if (!(t instanceof NonTransientDataAccessException)) {
            return false;
        }
        HashSet<Throwable> set = new HashSet<Throwable>();
        while (t != null && set.add(t)) {
            String exMessage = t.getMessage();
            if (exMessage != null && exMessage.contains("NOSCRIPT")) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }
}

