/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.common.util.ObjectUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public final class RpcControllerUtils {
    public static Object[] parseQueryParameters(Method method, Map<String, String[]> parameterMap) {
        int parameterCount = method.getParameterCount();
        Object[] arguments = new Object[parameterCount];
        for (int i = 0; i < parameterCount; ++i) {
            String argName = RpcControllerUtils.getQueryParameterName(i);
            String[] array = parameterMap.get(argName);
            if (array != null && array.length > 1) {
                throw new IllegalArgumentException(argName + " cannot be multiple value: " + Jsons.toJson(array));
            }
            String argValue = Collects.get(array, 0);
            Type argType = method.getGenericParameterTypes()[i];
            arguments[i] = argValue == null ? (argType instanceof Class ? ObjectUtils.cast(null, (Class)argType) : null) : Jsons.fromJson(argValue, argType);
        }
        return arguments;
    }

    public static MultiValueMap<String, String> buildQueryParameters(Object ... arguments) {
        if (ArrayUtils.isEmpty((Object[])arguments)) {
            return null;
        }
        LinkedMultiValueMap params = new LinkedMultiValueMap(arguments.length << 1);
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) continue;
            params.add((Object)RpcControllerUtils.getQueryParameterName(i), (Object)Jsons.toJson(arguments[i]));
        }
        return params;
    }

    public static String getQueryParameterName(int argIndex) {
        return "args[" + argIndex + "]";
    }
}

