/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.util.ClassUtils;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringContextHolder
implements ApplicationContextAware,
BeanFactoryPostProcessor {
    private static ApplicationContext applicationContext;
    private static ConfigurableListableBeanFactory beanFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setApplicationContext(ApplicationContext ctx) {
        Class<SpringContextHolder> clazz = SpringContextHolder.class;
        synchronized (SpringContextHolder.class) {
            if (applicationContext != null) {
                throw new IllegalStateException("Spring context holder already initialized.");
            }
            applicationContext = Objects.requireNonNull(ctx);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessBeanFactory(ConfigurableListableBeanFactory bf) throws BeansException {
        Class<SpringContextHolder> clazz = SpringContextHolder.class;
        synchronized (SpringContextHolder.class) {
            if (beanFactory != null) {
                throw new IllegalStateException("Spring context holder already initialized.");
            }
            beanFactory = Objects.requireNonNull(bf);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static ApplicationContext getApplicationContext() {
        return Objects.requireNonNull(applicationContext, "ApplicationContext is null.");
    }

    public static ListableBeanFactory getListableBeanFactory() {
        if (beanFactory != null) {
            return beanFactory;
        }
        return (ListableBeanFactory)Objects.requireNonNull(applicationContext, "ListableBeanFactory is null.");
    }

    public static ConfigurableListableBeanFactory getConfigurableListableBeanFactory() {
        if (beanFactory != null) {
            return beanFactory;
        }
        if (applicationContext instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        }
        throw applicationContext == null ? new NullPointerException("ConfigurableListableBeanFactory is null.") : new UnsupportedOperationException("ApplicationContext is not ConfigurableListableBeanFactory.");
    }

    public static boolean isNotNull() {
        return beanFactory != null || applicationContext != null;
    }

    public static String getProperty(String key) {
        ApplicationContext ctx = applicationContext;
        return ctx != null ? ctx.getEnvironment().getProperty(key) : null;
    }

    public static void publishEvent(Object event) {
        SpringContextHolder.getApplicationContext().publishEvent(event);
    }

    public static <T> T getBean(String beanName) {
        return (T)SpringContextHolder.getListableBeanFactory().getBean(beanName);
    }

    public static <T> T getBean(Class<T> beanType) {
        return (T)SpringContextHolder.getListableBeanFactory().getBean(beanType);
    }

    public static <T> T getBean(String beanName, Class<T> beanType) {
        return (T)SpringContextHolder.getListableBeanFactory().getBean(beanName, beanType);
    }

    public static <T> T getPrototypeBean(String beanName) throws IllegalStateException {
        Object bean;
        ListableBeanFactory factory = SpringContextHolder.getListableBeanFactory();
        try {
            bean = factory.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException ignored) {
            return null;
        }
        if (!factory.isPrototype(beanName)) {
            throw new IllegalStateException("Bean name is not a prototype bean: " + beanName);
        }
        return (T)bean;
    }

    public static <T> T getPrototypeBean(Class<T> beanType) throws IllegalStateException {
        Object bean;
        ListableBeanFactory factory = SpringContextHolder.getListableBeanFactory();
        try {
            bean = factory.getBean(beanType);
        }
        catch (NoSuchBeanDefinitionException ignored) {
            return null;
        }
        for (String beanName : factory.getBeanNamesForType(beanType)) {
            if (factory.isPrototype(beanName)) continue;
            throw new IllegalStateException("Bean type is not a prototype bean: " + beanType);
        }
        return (T)bean;
    }

    public static <T> T getPrototypeBean(String beanName, Class<T> beanType) throws IllegalStateException {
        Object bean;
        ListableBeanFactory factory = SpringContextHolder.getListableBeanFactory();
        try {
            bean = factory.getBean(beanName, beanType);
        }
        catch (NoSuchBeanDefinitionException ignored) {
            return null;
        }
        if (!factory.isPrototype(beanName)) {
            throw new IllegalStateException("Bean name is not a prototype bean: " + beanName + ", " + beanType);
        }
        return (T)bean;
    }

    public static <T> T getSingletonBean(String beanName) throws IllegalStateException {
        Object bean;
        ListableBeanFactory factory = SpringContextHolder.getListableBeanFactory();
        try {
            bean = factory.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException ignored) {
            return null;
        }
        if (!factory.isSingleton(beanName)) {
            throw new IllegalStateException("Bean name is not a prototype bean: " + beanName);
        }
        return (T)bean;
    }

    public static <T> T getSingletonBean(Class<T> beanType) throws IllegalStateException {
        Object bean;
        ListableBeanFactory factory = SpringContextHolder.getListableBeanFactory();
        try {
            bean = factory.getBean(beanType);
        }
        catch (NoSuchBeanDefinitionException ignored) {
            return null;
        }
        for (String beanName : factory.getBeanNamesForType(beanType)) {
            if (factory.isSingleton(beanName)) continue;
            throw new IllegalStateException("Bean type is not a singleton bean: " + beanType);
        }
        return (T)bean;
    }

    public static <T> T getSingletonBean(String beanName, Class<T> beanType) throws IllegalStateException {
        Object bean;
        ListableBeanFactory factory = SpringContextHolder.getListableBeanFactory();
        try {
            bean = factory.getBean(beanName, beanType);
        }
        catch (NoSuchBeanDefinitionException ignored) {
            return null;
        }
        if (!factory.isSingleton(beanName)) {
            throw new IllegalStateException("Bean name is not a singleton bean: " + beanName + ", " + beanType);
        }
        return (T)bean;
    }

    public static boolean containsBean(String beanName) {
        return SpringContextHolder.getListableBeanFactory().containsBean(beanName);
    }

    public static Class<?> getType(String beanName) {
        return SpringContextHolder.getListableBeanFactory().getType(beanName);
    }

    public static String[] getAliases(String beanName) {
        return SpringContextHolder.getApplicationContext().getAliases(beanName);
    }

    public static void registerSingleton(String beanName, Object bean) {
        ConfigurableListableBeanFactory factory = SpringContextHolder.getConfigurableListableBeanFactory();
        factory.autowireBean(bean);
        factory.registerSingleton(beanName, bean);
    }

    public static void destroySingleton(String beanName) {
        ConfigurableListableBeanFactory factory = SpringContextHolder.getConfigurableListableBeanFactory();
        if (factory instanceof DefaultSingletonBeanRegistry) {
            ((DefaultSingletonBeanRegistry)factory).destroySingleton(beanName);
        }
        throw new UnsupportedOperationException("Unsupported destroy Singleton: " + ClassUtils.getObjectClassName(factory));
    }

    public static <T> T registerBeanDefinition(String beanName, Class<T> beanType, Object ... args) {
        ApplicationContext ac = SpringContextHolder.getApplicationContext();
        if (!(ac instanceof ConfigurableApplicationContext)) {
            throw new UnsupportedOperationException("Unsupported register bean definition: " + ClassUtils.getObjectClassName(ac));
        }
        BeanDefinitionBuilder bdb = BeanDefinitionBuilder.genericBeanDefinition(beanType);
        for (Object arg : args) {
            bdb.addConstructorArgValue(arg);
        }
        ConfigurableApplicationContext cac = (ConfigurableApplicationContext)ac;
        BeanDefinitionRegistry bdr = (BeanDefinitionRegistry)cac.getBeanFactory();
        bdr.registerBeanDefinition(beanName, (BeanDefinition)bdb.getRawBeanDefinition());
        return (T)cac.getBean(beanName, beanType);
    }

    public static void removeBeanDefinition(String beanName) {
        ApplicationContext ac = SpringContextHolder.getApplicationContext();
        if (!(ac instanceof ConfigurableApplicationContext)) {
            throw new UnsupportedOperationException("Unsupported remove bean definition: " + ClassUtils.getObjectClassName(ac));
        }
        ConfigurableApplicationContext cac = (ConfigurableApplicationContext)ac;
        ((BeanDefinitionRegistry)cac.getBeanFactory()).removeBeanDefinition(beanName);
    }

    public static void autowireBean(Object bean) {
        SpringContextHolder.getApplicationContext().getAutowireCapableBeanFactory().autowireBean(bean);
    }
}

