/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.exception.Throwables;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.core.NamedThreadLocal;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;

public class TransactionUtils {
    private static final ThreadLocal<Boolean> DO_AFTER_COMMIT = new NamedThreadLocal("Transaction doAfterCommit");
    private static final int AFFECTED_ONE_ROW = 1;

    public static boolean isNotAffectedRow(int totalAffectedRow) {
        return totalAffectedRow < 1;
    }

    public static boolean isOneAffectedRow(int totalAffectedRow) {
        return totalAffectedRow == 1;
    }

    public static boolean hasAffectedRow(int totalAffectedRow) {
        return totalAffectedRow >= 1;
    }

    public static void assertNotAffectedRow(int totalAffectedRow, Supplier<String> errorMsgSupplier) {
        if (totalAffectedRow >= 1) {
            throw new IllegalStateException(errorMsgSupplier.get());
        }
    }

    public static void assertNotAffectedRow(int totalAffectedRow, String errorMsg) {
        if (totalAffectedRow >= 1) {
            throw new IllegalStateException(errorMsg);
        }
    }

    public static void assertOneAffectedRow(int totalAffectedRow, Supplier<String> errorMsgSupplier) {
        if (totalAffectedRow != 1) {
            throw new IllegalStateException(errorMsgSupplier.get());
        }
    }

    public static void assertOneAffectedRow(int totalAffectedRow, String errorMsg) {
        if (totalAffectedRow != 1) {
            throw new IllegalStateException(errorMsg);
        }
    }

    public static void assertHasAffectedRow(int totalAffectedRow, Supplier<String> errorMsgSupplier) {
        if (totalAffectedRow < 1) {
            throw new IllegalStateException(errorMsgSupplier.get());
        }
    }

    public static void assertHasAffectedRow(int totalAffectedRow, String errorMsg) {
        if (totalAffectedRow < 1) {
            throw new IllegalStateException(errorMsg);
        }
    }

    public static void doAfterTransactionCommit(Collection<Runnable> actions) {
        if (actions != null) {
            actions.forEach(TransactionUtils::doAfterTransactionCommit);
        }
    }

    public static void doAfterTransactionCommit(final Runnable action) {
        if (action == null) {
            return;
        }
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronization ts = new TransactionSynchronization(){

                public void afterCommit() {
                    boolean readOnly = TransactionSynchronizationManager.isCurrentTransactionReadOnly();
                    if (!readOnly) {
                        TransactionSynchronizationManager.setCurrentTransactionReadOnly((boolean)true);
                    }
                    DO_AFTER_COMMIT.set(Boolean.TRUE);
                    try {
                        action.run();
                    }
                    finally {
                        DO_AFTER_COMMIT.remove();
                        if (!readOnly) {
                            TransactionSynchronizationManager.setCurrentTransactionReadOnly((boolean)false);
                        }
                    }
                }
            };
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)ts);
        } else {
            action.run();
        }
    }

    public static boolean isCurrentDoAfterCommit() {
        return Boolean.TRUE.equals(DO_AFTER_COMMIT.get());
    }

    public static boolean isWithinTransaction() {
        return TransactionSynchronizationManager.isActualTransactionActive() && !TransactionUtils.isCurrentDoAfterCommit();
    }

    public static boolean isWithoutTransaction() {
        return !TransactionUtils.isWithinTransaction();
    }

    public static void assertWithinTransaction() {
        Assert.isTrue((boolean)TransactionUtils.isWithinTransaction(), (String)"Must be within transaction.");
    }

    public static void assertWithoutTransaction() {
        Assert.isTrue((boolean)TransactionUtils.isWithoutTransaction(), (String)"Must be without transaction.");
    }

    public static <R> R doInRequiresNewTransaction(PlatformTransactionManager txManager, Throwables.ThrowingSupplier<R, Throwable> action, Consumer<Throwable> errorHandler) {
        return TransactionUtils.doInPropagationTransaction(txManager, action, errorHandler, 3);
    }

    public static <R> R doInNestedTransaction(TransactionTemplate transactionTemplate, Throwables.ThrowingSupplier<R, Throwable> action, Consumer<Throwable> errorHandler) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            PlatformTransactionManager txManager = transactionTemplate.getTransactionManager();
            return TransactionUtils.doInPropagationTransaction(txManager, action, errorHandler, 6);
        }
        throw new IllegalStateException("Do nested transaction must be in parent transaction.");
    }

    private static <R> R doInPropagationTransaction(PlatformTransactionManager txManager, Throwables.ThrowingSupplier<R, Throwable> action, Consumer<Throwable> errorHandler, int transactionPropagation) {
        Objects.requireNonNull(txManager, "Transaction manager cannot be null.");
        DefaultTransactionDefinition txDefinition = new DefaultTransactionDefinition();
        txDefinition.setPropagationBehavior(transactionPropagation);
        TransactionStatus status = txManager.getTransaction((TransactionDefinition)txDefinition);
        try {
            R result = action.get();
            txManager.commit(status);
            return result;
        }
        catch (Throwable t) {
            txManager.rollback(status);
            errorHandler.accept(t);
            return null;
        }
    }
}

