/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.spring;

import cn.ponfee.disjob.common.collect.TypedMap;
import cn.ponfee.disjob.common.spring.YamlPropertySourceFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class YamlProperties
extends Properties
implements TypedMap<Object, Object> {
    private static final long serialVersionUID = -1599483902442715272L;
    private Binder binder;

    public YamlProperties(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.loadYaml(inputStream);
        }
    }

    public YamlProperties(InputStream inputStream) {
        this.loadYaml(inputStream);
    }

    public YamlProperties(byte[] content) {
        this.loadYaml(new ByteArrayInputStream(content));
    }

    public <T> T bind(String name, Class<T> beanType) {
        if (this.binder == null) {
            this.binder = new Binder(new ConfigurationPropertySource[]{new MapConfigurationPropertySource((Map)this)});
        }
        return (T)this.binder.bind(name, beanType).get();
    }

    private void loadYaml(InputStream inputStream) {
        InputStreamResource resource = new InputStreamResource(inputStream);
        super.putAll((Map<?, ?>)YamlPropertySourceFactory.loadYml((Resource)resource));
    }
}

