/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.tree;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.common.tree.NodePath;
import cn.ponfee.disjob.common.util.Comparators;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class NodeId<T extends NodeId<T>>
extends ToJsonString
implements Comparable<T>,
Serializable {
    private static final long serialVersionUID = -9004940918491918780L;
    protected final T parent;

    protected NodeId(T parent) {
        this.parent = parent;
    }

    public int hashCode() {
        return Objects.hashCode(this.parent);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return Objects.equals(this.parent, ((NodeId)obj).parent);
    }

    @Override
    public int compareTo(@Nonnull T that) {
        return Comparators.compareNullsFirst(this.parent, ((NodeId)that).parent);
    }

    public <E extends Serializable & Comparable<E>> NodePath<E> toNodePath(Function<T, E> mapper) {
        LinkedList<E> path = new LinkedList<E>();
        NodeId<T> node = this;
        while (node != null) {
            path.addFirst(mapper.apply(node));
            node = node.parent;
        }
        return new NodePath(path);
    }

    public T getParent() {
        return this.parent;
    }
}

