/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.tree;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.util.Assert;

public class PlainNode<T extends Serializable & Comparable<T>, A>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4116799955526185765L;
    protected final T id;
    protected final T parentId;
    protected final boolean enabled;
    protected final boolean available;
    protected final A attach;

    public PlainNode(T id, T parentId) {
        this(id, parentId, true, true, null);
    }

    public PlainNode(T id, T parentId, boolean enabled, boolean available, A attach) {
        PlainNode.checkNodeId(id, parentId);
        this.id = id;
        this.parentId = parentId;
        this.enabled = enabled;
        this.available = enabled && available;
        this.attach = attach;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.equalsId(((PlainNode)obj).id);
    }

    public PlainNode<T, A> clone() {
        return (PlainNode)SerializationUtils.clone((Serializable)this);
    }

    public boolean equalsId(T id) {
        return Objects.equals(this.id, id);
    }

    private static <T extends Serializable & Comparable<T>> void checkNodeId(T id, T parentId) {
        if (id == null) {
            Assert.isNull(parentId, (String)"Parent id must be null when node id is null.");
        } else {
            Assert.isTrue((!id.equals(parentId) ? 1 : 0) != 0, (String)"Node id cannot equals parent id.");
        }
        if (parentId != null) {
            Assert.notNull(id, (String)"Node id cannot be null when parent id is not null.");
        }
    }

    public T getId() {
        return this.id;
    }

    public T getParentId() {
        return this.parentId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public A getAttach() {
        return this.attach;
    }
}

