/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.tree;

import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.tree.BaseTree;
import cn.ponfee.disjob.common.tree.FlatNode;
import cn.ponfee.disjob.common.tree.NodePath;
import cn.ponfee.disjob.common.tree.PlainNode;
import cn.ponfee.disjob.common.tree.TreeTrait;
import cn.ponfee.disjob.common.tree.print.MultiwayTreePrinter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.util.Assert;

public final class TreeNode<T extends Serializable & Comparable<T>, A>
extends BaseTree<T, A> {
    private static final long serialVersionUID = -9081626363752680404L;
    private final List<TreeNode<T, A>> children = new ArrayList<TreeNode<T, A>>();

    public TreeNode(T id, T parentId) {
        super(id, parentId);
    }

    public TreeNode(T id, T parentId, boolean enabled, boolean available, A attach) {
        super(id, parentId, enabled, available, attach);
    }

    public static <T extends Serializable & Comparable<T>, A> TreeNode<T, A> root(T id) {
        return new TreeNode<Object, A>(id, null);
    }

    public static <T extends Serializable & Comparable<T>, A, E extends PlainNode<T, A>> TreeNode<T, A> build(List<E> list) {
        return TreeNode.build(list, false, Comparator.comparing(PlainNode::getId));
    }

    public static <T extends Serializable & Comparable<T>, A, E extends PlainNode<T, A>> TreeNode<T, A> build(List<E> list, boolean buildPath, Comparator<? super TreeNode<T, A>> siblingNodesComparator) {
        TreeNode<Serializable, A> root;
        Assert.notEmpty(list, (String)"Build list cannot be empty.");
        Set<PlainNode<T, A>> roots = TreeNode.findRoots(list);
        if (roots.isEmpty()) {
            throw new IllegalArgumentException("Not found root node.");
        }
        if (roots.size() == 1) {
            PlainNode fd = roots.iterator().next();
            root = fd instanceof TreeNode ? (TreeNode<Serializable, A>)fd : new TreeNode(fd.id, fd.parentId, fd.enabled, fd.available, fd.attach);
            list = list.stream().filter(e -> !e.equals(fd)).collect(Collectors.toList());
        } else {
            List rootIds = roots.stream().map(e -> e.parentId).distinct().collect(Collectors.toList());
            Assert.state((rootIds.size() == 1 ? 1 : 0) != 0, () -> "Found many root node id: " + rootIds);
            root = TreeNode.root((Serializable)rootIds.get(0));
        }
        root.mount(list, false, buildPath, siblingNodesComparator);
        return root;
    }

    public <E extends PlainNode<T, A>> void mount(List<E> list) {
        this.mount(list, false, false, Comparator.comparing(PlainNode::getId));
    }

    public <E extends PlainNode<T, A>> void mount(List<E> list, boolean ignoreIsolated, boolean buildPath, Comparator<? super TreeNode<T, A>> siblingNodesComparator) {
        Objects.requireNonNull(siblingNodesComparator, "Sibling nodes comparator cannot be null.");
        List<PlainNode<T, A>> nodes = this.prepare(list);
        this.check(nodes);
        this.mount(nodes, siblingNodesComparator);
        if (!ignoreIsolated && CollectionUtils.isNotEmpty(nodes)) {
            throw new IllegalStateException("Isolated node ids: " + Collects.convert(nodes, PlainNode::getId));
        }
        this.count(buildPath);
    }

    public TreeNode<T, A> getNode(T id) {
        ArrayDeque<TreeNode> stack = Collects.newArrayDeque(this);
        while (!stack.isEmpty()) {
            TreeNode node = (TreeNode)stack.pop();
            if (node.equalsId(id)) {
                return node;
            }
            node.forEachChild(stack::push);
        }
        return null;
    }

    public TreeNode<T, A> removeNode(T id) {
        TreeNode<T, A> removed = this.removeNode0(id);
        if (removed != null && removed != this) {
            boolean buildPath = this.path != null;
            this.count(buildPath);
            super.count(buildPath);
        }
        return removed;
    }

    public List<FlatNode<T, A>> flatDFS() {
        ArrayList<FlatNode<T, A>> list = new ArrayList<FlatNode<T, A>>(this.treeNodeCount);
        ArrayDeque<TreeNode> stack = Collects.newArrayDeque(this);
        while (!stack.isEmpty()) {
            TreeNode node = (TreeNode)stack.pop();
            list.add(new FlatNode(node));
            Lists.reverse(node.children).forEach(stack::push);
        }
        return list;
    }

    public List<FlatNode<T, A>> flatCFS() {
        ArrayList list = Collects.newArrayList(this.treeNodeCount, new FlatNode(this));
        ArrayDeque<TreeNode> stack = Collects.newArrayDeque(this);
        while (!stack.isEmpty()) {
            TreeNode node = (TreeNode)stack.pop();
            node.forEachChild(child -> list.add(new FlatNode(child)));
            Lists.reverse(node.children).forEach(stack::push);
        }
        return list;
    }

    public List<FlatNode<T, A>> flatBFS() {
        ArrayList list = new ArrayList(this.treeNodeCount);
        this.traverse(node -> list.add(new FlatNode(node)));
        return list;
    }

    public void forEachChild(Consumer<TreeNode<T, A>> childProcessor) {
        if (!this.children.isEmpty()) {
            this.children.forEach(childProcessor);
        }
    }

    public void traverse(Consumer<TreeNode<T, A>> action) {
        ArrayDeque<TreeNode> queue = Collects.newArrayDeque(this);
        while (!queue.isEmpty()) {
            for (int i = queue.size(); i > 0; --i) {
                TreeNode node = (TreeNode)Objects.requireNonNull(queue.poll());
                action.accept(node);
                node.forEachChild(queue::offer);
            }
        }
    }

    public <E extends TreeTrait<T, A, E>> E convert(Function<TreeNode<T, A>, E> converter, boolean includeUnavailable) {
        if (this.available || includeUnavailable) {
            TreeTrait root = (TreeTrait)converter.apply(this);
            this.convert(converter, includeUnavailable, root);
            return (E)root;
        }
        return null;
    }

    public void print(Appendable output, Function<TreeNode<T, A>, CharSequence> nodeLabel) throws IOException {
        new MultiwayTreePrinter<TreeNode>(output, nodeLabel, TreeNode::getChildren).print(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        try {
            this.print(builder, e -> String.valueOf(e.id));
            return builder.toString();
        }
        catch (IOException e2) {
            return (String)ExceptionUtils.rethrow((Throwable)e2);
        }
    }

    private static <T extends Serializable & Comparable<T>, A> Set<PlainNode<T, A>> findRoots(List<PlainNode<T, A>> list) {
        List<PlainNode<T, A>> nodes = TreeNode.flatten(list);
        HashSet childIds = new HashSet(nodes.size() * 2);
        for (PlainNode<T, A> node : nodes) {
            Assert.state((!childIds.contains(node.id) ? 1 : 0) != 0, () -> "Found duplicated node id: " + node.id);
            childIds.add(node.id);
        }
        HashSet<PlainNode<T, A>> roots = new HashSet<PlainNode<T, A>>();
        for (PlainNode<T, A> node : nodes) {
            if (node.id != null && childIds.contains(node.parentId)) continue;
            roots.add(node);
        }
        return roots;
    }

    private static <T extends Serializable & Comparable<T>, A> List<PlainNode<T, A>> flatten(List<PlainNode<T, A>> list) {
        LinkedList<PlainNode<T, A>> nodes = new LinkedList<PlainNode<T, A>>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (PlainNode<T, A> node : list) {
                if (node instanceof TreeNode) {
                    ((TreeNode)node).traverse(nodes::add);
                    continue;
                }
                nodes.add(node);
            }
        }
        return nodes;
    }

    private List<PlainNode<T, A>> prepare(List<PlainNode<T, A>> list) {
        List nodes = TreeNode.flatten(list);
        this.forEachChild(child -> child.traverse(nodes::add));
        this.children.clear();
        return nodes;
    }

    private void check(List<PlainNode<T, A>> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        HashMap<Serializable, Serializable> graph = new HashMap<Serializable, Serializable>(nodes.size() * 2);
        graph.put(this.id, this.parentId);
        for (PlainNode<T, A> node : nodes) {
            Assert.state((!graph.containsKey(node.id) ? 1 : 0) != 0, () -> "Duplicated node id: " + node.id);
            graph.put((Serializable)node.id, (Serializable)node.parentId);
        }
        HashSet set = new HashSet();
        for (Serializable nodeId : graph.keySet()) {
            if (!TreeNode.hasCycle(nodeId, set, graph)) continue;
            throw new IllegalStateException("Cycled node id: " + nodeId);
        }
    }

    private static <T> boolean hasCycle(T id, Set<T> set, Map<T, T> graph) {
        if (!set.add(id)) {
            return true;
        }
        if (graph.containsKey(id)) {
            T parentId = graph.get(id);
            if (id != null && TreeNode.hasCycle(parentId, set, graph)) {
                return true;
            }
        }
        set.remove(id);
        return false;
    }

    private <E extends PlainNode<T, A>> void mount(List<E> nodes, Comparator<? super TreeNode<T, A>> siblingNodesComparator) {
        Iterator<E> iter = nodes.iterator();
        while (iter.hasNext()) {
            PlainNode node = (PlainNode)iter.next();
            if (!this.equalsId(node.parentId)) continue;
            boolean nodeAvailable = node.available && this.available;
            this.children.add(new TreeNode(node.id, node.parentId, node.enabled, nodeAvailable, node.attach));
            iter.remove();
        }
        this.forEachChild(child -> child.mount(nodes, siblingNodesComparator));
        this.children.sort(siblingNodesComparator);
    }

    private void count(boolean buildPath) {
        this.level = 0;
        this.siblingOrdinal = 0;
        this.leftLeafCount = 0;
        this.count(buildPath, new NodePath());
    }

    private void count(boolean buildPath, NodePath<T> parentPath) {
        this.path = buildPath ? new NodePath<Serializable>(parentPath, this.id) : null;
        this.nodeDegree = this.children.size();
        if (this.children.isEmpty()) {
            this.treeDegree = 0;
            this.treeHeight = 0;
            this.treeNodeCount = 1;
            this.treeLeafCount = 1;
        } else {
            int maxChildTreeDegree = 0;
            int maxChildTreeHeight = 0;
            int sumChildTreeNodeCount = 0;
            int sumChildTreeLeafCount = 0;
            int n = this.children.size();
            for (int i = 0; i < n; ++i) {
                TreeNode<T, A> child = this.children.get(i);
                child.level = this.level + 1;
                child.siblingOrdinal = i;
                if (i == 0) {
                    child.leftLeafCount = this.leftLeafCount;
                } else {
                    TreeNode<T, A> prevSibling = this.children.get(i - 1);
                    child.leftLeafCount = prevSibling.leftLeafCount + prevSibling.treeLeafCount;
                }
                super.count(buildPath, this.path);
                maxChildTreeDegree = Math.max(maxChildTreeDegree, child.treeDegree);
                maxChildTreeHeight = Math.max(maxChildTreeHeight, child.treeHeight);
                sumChildTreeNodeCount += child.treeNodeCount;
                sumChildTreeLeafCount += child.treeLeafCount;
            }
            this.treeDegree = Math.max(maxChildTreeDegree, this.nodeDegree);
            this.treeHeight = maxChildTreeHeight + 1;
            this.treeNodeCount = sumChildTreeNodeCount + 1;
            this.treeLeafCount = sumChildTreeLeafCount;
        }
    }

    private <E extends TreeTrait<T, A, E>> void convert(Function<TreeNode<T, A>, E> converter, boolean includeUnavailable, E parent) {
        ArrayList<TreeTrait> list = new ArrayList<TreeTrait>(this.children.size());
        for (TreeNode<T, A> child : this.children) {
            if (!child.available && !includeUnavailable) continue;
            TreeTrait node = (TreeTrait)converter.apply(child);
            super.convert(converter, includeUnavailable, node);
            list.add(node);
        }
        parent.setChildren(list);
    }

    private TreeNode<T, A> removeNode0(T id) {
        if (this.equalsId(id)) {
            return this;
        }
        ArrayDeque<TreeNode> stack = Collects.newArrayDeque(this);
        while (!stack.isEmpty()) {
            TreeNode node = (TreeNode)stack.pop();
            Iterator<TreeNode<T, A>> iter = node.children.iterator();
            while (iter.hasNext()) {
                TreeNode<T, A> child = iter.next();
                if (child.equalsId(id)) {
                    iter.remove();
                    return child;
                }
                stack.push(child);
            }
        }
        return null;
    }

    public List<TreeNode<T, A>> getChildren() {
        return this.children;
    }
}

