/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.tree.print;

import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.tuple.Tuple4;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.function.Function;

public final class MultiwayTreePrinter<T> {
    private final Appendable output;
    private final Function<T, CharSequence> nodeLabel;
    private final Function<T, List<T>> nodeChildren;

    public MultiwayTreePrinter(Appendable output, Function<T, CharSequence> nodeLabel, Function<T, List<T>> nodeChildren) {
        this.output = output;
        this.nodeLabel = nodeLabel;
        this.nodeChildren = nodeChildren;
    }

    public void print(T root) throws IOException {
        ArrayDeque<Tuple4<T, String, Object, String>> stack = Collects.newArrayDeque(Tuple4.of(root, "", null, ""));
        while (!stack.isEmpty()) {
            Tuple4 tuple = (Tuple4)stack.pop();
            this.output.append((CharSequence)tuple.b).append((CharSequence)tuple.d).append(this.nodeLabel.apply(tuple.a)).append('\n');
            List<T> children = this.nodeChildren.apply(tuple.a);
            if (children == null || children.isEmpty()) continue;
            String indent = tuple.c == null ? (String)tuple.b : (String)tuple.b + (String)tuple.c;
            int index = 0;
            for (Object child : Lists.reverse(children)) {
                if (index++ == 0) {
                    stack.push(Tuple4.of(child, indent, "    ", "\u2514\u2500\u2500 "));
                    continue;
                }
                stack.push(Tuple4.of(child, indent, "\u2502   ", "\u251c\u2500\u2500 "));
            }
        }
    }
}

