/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.tuple;

import cn.ponfee.disjob.common.collect.DelegatedIntSpliterator;
import cn.ponfee.disjob.common.util.Comparators;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class Tuple
implements Comparable<Object>,
Iterable<Object>,
Serializable {
    private static final long serialVersionUID = -3292038317953347997L;

    public abstract <T> T get(int var1);

    public abstract <T> void set(T var1, int var2);

    public abstract <T extends Tuple> T copy();

    public abstract int length();

    public final Object[] toArray() {
        int len = this.length();
        Object[] array = new Object[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    public final String toString() {
        return this.join(", ", String::valueOf, "(", ")");
    }

    public final int hashCode() {
        int len = this.length();
        if (len < 1) {
            return 0;
        }
        int hash = Objects.hashCode(this.get(0));
        for (int i = 1; i < len; ++i) {
            hash = 31 * hash + Objects.hashCode(this.get(i));
        }
        return hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Tuple that = (Tuple)obj;
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            if (Objects.equals(this.get(i), that.get(i))) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object ... elements) {
        int len;
        if (elements == null || elements.length != (len = this.length())) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Objects.equals(this.get(i), elements[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int compareTo(@Nonnull Object obj) {
        if (this == obj) {
            return 0;
        }
        if (this.getClass() != obj.getClass()) {
            return Comparators.compare(this, obj);
        }
        Tuple that = (Tuple)obj;
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            int compared = Comparators.compare(this.get(i), that.get(i));
            if (compared == 0) continue;
            return compared;
        }
        return 0;
    }

    public List<Object> toList() {
        return Arrays.asList(this.toArray());
    }

    @Override
    public Iterator<Object> iterator() {
        return new TupleIterator<Object>();
    }

    @Override
    public final void forEach(Consumer<? super Object> action) {
        Objects.requireNonNull(action);
        int len = this.length();
        for (int i = 0; i < len; ++i) {
            action.accept(this.get(i));
        }
    }

    @Override
    public Spliterator<Object> spliterator() {
        return new DelegatedIntSpliterator<Object>(0, this.length(), this::get);
    }

    public final String join(CharSequence delimiter, Function<Object, String> valueMapper, CharSequence prefix, CharSequence suffix) {
        StringBuilder builder = new StringBuilder(prefix);
        int n = this.length() - 1;
        for (int i = 0; i <= n; ++i) {
            builder.append(valueMapper.apply(this.get(i)));
            if (i >= n) continue;
            builder.append(delimiter);
        }
        return builder.append(suffix).toString();
    }

    private class TupleIterator<T>
    implements Iterator<T> {
        private int position = 0;
        private final int size = Tuple.this.length();

        private TupleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < this.size;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return Tuple.this.get(this.position++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

