/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import cn.ponfee.disjob.common.base.Null;
import cn.ponfee.disjob.common.collect.ArrayHashKey;
import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.tuple.Tuple2;
import cn.ponfee.disjob.common.tuple.Tuple3;
import cn.ponfee.disjob.common.util.GroovyUtils;
import cn.ponfee.disjob.common.util.Jsons;
import cn.ponfee.disjob.common.util.Predicates;
import cn.ponfee.disjob.common.util.PrimitiveTypes;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.objenesis.ObjenesisHelper;
import org.springframework.util.Assert;

public final class ClassUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ClassUtils.class);
    public static final Pattern QUALIFIED_CLASS_NAME_PATTERN = Pattern.compile("^([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*[a-zA-Z_$][a-zA-Z\\d_$]*$");
    private static final ConcurrentMap<Object, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<Object, Method> METHOD_CACHE = new ConcurrentHashMap<Object, Method>();

    public static <T> Class<T> getClass(String text) {
        if (QUALIFIED_CLASS_NAME_PATTERN.matcher(text).matches()) {
            try {
                return Class.forName(text);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return GroovyUtils.parseClass(text);
        }
        catch (Exception e) {
            LOG.warn("Parse source class code occur error.", (Throwable)e);
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        if (clazz.isInterface() || clazz == Object.class) {
            return null;
        }
        Exception firstOccurException = null;
        do {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                if (!Modifier.isStatic(field.getModifiers())) {
                    return field;
                }
            }
            catch (Exception e) {
                if (firstOccurException != null) continue;
                firstOccurException = e;
            }
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        return (Field)ExceptionUtils.rethrow((Throwable)firstOccurException);
    }

    public static Set<String> fieldDiff(Class<?> a, Class<?> b) {
        Set set1 = ClassUtils.listFields(a).stream().map(Field::getName).collect(Collectors.toSet());
        Set set2 = ClassUtils.listFields(b).stream().map(Field::getName).collect(Collectors.toSet());
        return Sets.symmetricDifference(set1, set2);
    }

    public static List<Field> listFields(Class<?> clazz) {
        if (clazz.isInterface() || clazz == Object.class) {
            throw new IllegalArgumentException("Class cannot be interface or Object.class: " + clazz);
        }
        ArrayList<Field> list = new ArrayList<Field>();
        do {
            try {
                for (Field field : clazz.getDeclaredFields()) {
                    int mdf = field.getModifiers();
                    if (Modifier.isStatic(mdf) || Modifier.isTransient(mdf)) continue;
                    list.add(field);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        return list;
    }

    public static Field findStaticFieldIncludeSuperClass(Class<?> clazz, String staticFieldName) {
        if (clazz == Object.class) {
            throw new IllegalArgumentException("Cannot be Object.class");
        }
        Exception firstOccurException = null;
        LinkedList queue = new LinkedList();
        queue.offer(clazz);
        while (!queue.isEmpty()) {
            for (int i = queue.size(); i > 0; --i) {
                Class type;
                block7: {
                    type = (Class)queue.poll();
                    try {
                        Field field = type.getDeclaredField(staticFieldName);
                        if (Modifier.isStatic(field.getModifiers())) {
                            return field;
                        }
                    }
                    catch (Exception e) {
                        if (firstOccurException != null) break block7;
                        firstOccurException = e;
                    }
                }
                if (type.getSuperclass() != Object.class) {
                    queue.offer(type.getSuperclass());
                }
                Arrays.stream(type.getInterfaces()).forEach(queue::offer);
            }
        }
        return (Field)ExceptionUtils.rethrow(firstOccurException);
    }

    public static Field getStaticField(Class<?> clazz, String staticFieldName) {
        if (clazz == Object.class) {
            return null;
        }
        try {
            Field field = clazz.getDeclaredField(staticFieldName);
            if (Modifier.isStatic(field.getModifiers())) {
                return field;
            }
            throw new IllegalArgumentException("Non-static field " + clazz + "#" + staticFieldName);
        }
        catch (Exception e) {
            return (Field)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static String getObjectClassName(Object obj) {
        return obj == null ? null : obj.getClass().getName();
    }

    public static String getPackagePath(String packageName) {
        return packageName.replace('.', '/') + "/";
    }

    public static String getPackagePath(Class<?> clazz) {
        String className = clazz.getName();
        if (className.indexOf(46) < 0) {
            return "";
        }
        return ClassUtils.getPackagePath(className.substring(0, className.lastIndexOf(46)));
    }

    public static Class<?> findAnnotatedClass(Class<?> supClass, Class<?> subClass, Class<? extends Annotation> annClass) {
        if (supClass == null || subClass == null || !supClass.isAssignableFrom(subClass)) {
            return null;
        }
        ArrayDeque<Class<?>> stack = Collects.newArrayDeque(subClass);
        while (!stack.isEmpty()) {
            subClass = (Class)stack.pop();
            if (subClass.isAnnotationPresent(annClass)) {
                return subClass;
            }
            for (Class cls : Collects.concat(subClass.getInterfaces(), subClass.getSuperclass())) {
                if (cls == null || !supClass.isAssignableFrom(cls)) continue;
                stack.push(cls);
            }
        }
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> type, Class<?> ... parameterTypes) {
        boolean noArgs = ArrayUtils.isEmpty((Object[])parameterTypes);
        Class key = noArgs ? type : Tuple2.of(type, ArrayHashKey.of(parameterTypes));
        Constructor constructor = CONSTRUCTOR_CACHE.computeIfAbsent(key, k -> {
            try {
                return ClassUtils.getConstructor0(type, parameterTypes);
            }
            catch (Exception e) {
                LOG.warn("Get constructor occur error: {}", (Object)e.getMessage());
                return Null.BROKEN_CONSTRUCTOR;
            }
        });
        return constructor == Null.BROKEN_CONSTRUCTOR ? null : constructor;
    }

    public static <T> T newInstance(Constructor<T> constructor) {
        return ClassUtils.newInstance(constructor, null);
    }

    public static <T> T newInstance(Constructor<T> constructor, Object[] args) {
        ClassUtils.checkObjectArray(args);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        try {
            return ArrayUtils.isEmpty((Object[])args) ? constructor.newInstance(new Object[0]) : constructor.newInstance(args);
        }
        catch (Exception e) {
            return (T)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static <T> T newInstance(Class<T> type, Class<?>[] parameterTypes, Object[] args) {
        ClassUtils.checkObjectArray(args);
        ClassUtils.checkSameLength(parameterTypes, args);
        if (ArrayUtils.isEmpty((Object[])parameterTypes)) {
            return ClassUtils.newInstance(type, null);
        }
        Constructor<T> constructor = ClassUtils.getConstructor(type, parameterTypes);
        if (constructor == null) {
            throw new IllegalArgumentException("No such constructor: " + type + ClassUtils.toString(parameterTypes));
        }
        return ClassUtils.newInstance(constructor, args);
    }

    public static <T> T newInstance(Class<T> type) {
        return ClassUtils.newInstance(type, null);
    }

    public static <T> T newInstance(Class<T> type, Object[] args) {
        ClassUtils.checkObjectArray(args);
        if (ArrayUtils.isEmpty((Object[])args)) {
            Constructor<T> constructor = ClassUtils.getConstructor(type, new Class[0]);
            return (T)(constructor != null ? ClassUtils.newInstance(constructor, null) : ObjenesisHelper.newInstance(type));
        }
        Class<?>[] parameterTypes = ClassUtils.parseParameterTypes(args);
        Constructor<T> constructor = ClassUtils.obtainConstructor(type, parameterTypes);
        if (constructor == null) {
            throw new IllegalArgumentException("Not found constructor: " + type + ClassUtils.toString(parameterTypes));
        }
        return ClassUtils.newInstance(constructor, args);
    }

    public static Method getMethod(Object caller, String methodName, Class<?> ... parameterTypes) {
        Tuple2<Class<?>, Predicates> tuple = ClassUtils.obtainClass(caller);
        Class type = (Class)tuple.a;
        boolean noArgs = ArrayUtils.isEmpty((Object[])parameterTypes);
        Tuple2<Class, String> key = noArgs ? Tuple2.of(type, methodName) : Tuple3.of(type, methodName, ArrayHashKey.of(parameterTypes));
        Method method = METHOD_CACHE.computeIfAbsent(key, k -> {
            try {
                Method m = ClassUtils.getMethod0(type, methodName, parameterTypes);
                return ((Predicates)((Object)((Object)tuple.b))).equals(Modifier.isStatic(m.getModifiers())) && !m.isSynthetic() ? m : null;
            }
            catch (Exception e) {
                LOG.info("Get method failed: {}", (Object)e.getMessage());
                return Null.BROKEN_METHOD;
            }
        });
        return method == Null.BROKEN_METHOD ? null : method;
    }

    public static <T> T invoke(Object caller, Method method) {
        return ClassUtils.invoke(caller, method, null);
    }

    public static <T> T invoke(Object caller, Method method, Object[] args) {
        ClassUtils.checkObjectArray(args);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return (T)(ArrayUtils.isEmpty((Object[])args) ? method.invoke(caller, new Object[0]) : method.invoke(caller, args));
        }
        catch (Exception e) {
            return (T)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static <T> T invoke(Object caller, String methodName) {
        return ClassUtils.invoke(caller, methodName, (Class[])null, null);
    }

    public static <T> T invoke(Object caller, String methodName, Class<?>[] parameterTypes, Object[] args) {
        ClassUtils.checkObjectArray(args);
        ClassUtils.checkSameLength(parameterTypes, args);
        Method method = ClassUtils.getMethod(caller, methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("No such method: " + caller.getClass() + "#" + methodName + ClassUtils.toString(parameterTypes));
        }
        return ClassUtils.invoke(caller, method, args);
    }

    public static <T> T invoke(Object caller, String methodName, Object[] args) {
        ClassUtils.checkObjectArray(args);
        if (ArrayUtils.isEmpty((Object[])args)) {
            return ClassUtils.invoke(caller, methodName, (Class[])null, null);
        }
        Class<?>[] parameterTypes = ClassUtils.parseParameterTypes(args);
        Method method = ClassUtils.obtainMethod(caller, methodName, parameterTypes);
        if (method == null) {
            Class<?> clazz = caller instanceof Class ? (Class<?>)caller : caller.getClass();
            throw new IllegalArgumentException("Not found method: " + clazz + "#" + methodName + ClassUtils.toString(parameterTypes));
        }
        return ClassUtils.invoke(caller, method, args);
    }

    public static <T> T invoke(Object caller, String methodName, String jsonArgs, Class<?> ... parameterTypes) {
        Method method = ClassUtils.getMethod(caller, methodName, parameterTypes);
        Object[] args = Jsons.parseMethodArgs(jsonArgs, method);
        return ClassUtils.invoke(caller, method, args);
    }

    public static Tuple2<Class<?>, Predicates> obtainClass(Object obj) {
        if (obj instanceof Class && obj != Class.class) {
            return Tuple2.of((Class)obj, Predicates.Y);
        }
        return Tuple2.of(obj.getClass(), Predicates.N);
    }

    public static String getClassFilePath(Class<?> clazz) {
        URL url = clazz.getProtectionDomain().getCodeSource().getLocation();
        String path = new File(ClassUtils.decodeURL(url)).getAbsolutePath();
        if (path.toLowerCase().endsWith(".jar")) {
            path = path + "!";
        }
        return path + File.separator + clazz.getName().replace('.', File.separatorChar) + ".class";
    }

    public static String getClasspath(Class<?> clazz) {
        String path = ClassUtils.decodeURL(clazz.getProtectionDomain().getCodeSource().getLocation());
        if (path.toLowerCase().endsWith(".jar")) {
            path = path.substring(0, path.lastIndexOf("/") + 1);
        }
        return new File(path).getAbsolutePath() + File.separator;
    }

    public static String getClasspath() {
        URL url = Thread.currentThread().getContextClassLoader().getResource("");
        return new File(ClassUtils.decodeURL(url)).getAbsolutePath() + File.separator;
    }

    private static void checkSameLength(Object[] a, Object[] b) {
        if (!ArrayUtils.isSameLength((Object[])a, (Object[])b)) {
            throw new IllegalArgumentException("Different array length: " + Arrays.toString(a) + ", " + Arrays.toString(b));
        }
    }

    private static void checkObjectArray(Object[] array) {
        if (array != null && array.getClass() != Object[].class) {
            throw new IllegalArgumentException("Args must Object[] type, but actual is " + array.getClass().getSimpleName());
        }
    }

    private static Class<?>[] parseParameterTypes(Object[] args) {
        Assert.notEmpty((Object[])args, (String)"Should be always non empty.");
        Class[] parameterTypes = new Class[args.length];
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            parameterTypes[i] = args[i] == null ? null : args[i].getClass();
        }
        return parameterTypes;
    }

    private static Method getMethod0(Class<?> type, String methodName, Class<?>[] parameterTypes) throws Exception {
        try {
            return type.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            try {
                return type.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (Exception exception) {
                throw e;
            }
        }
    }

    private static <T> Constructor<T> getConstructor0(Class<T> type, Class<?>[] parameterTypes) throws Exception {
        try {
            return type.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            try {
                return type.getDeclaredConstructor(parameterTypes);
            }
            catch (Exception exception) {
                throw e;
            }
        }
    }

    private static <T> Constructor<T> obtainConstructor(Class<T> type, Class<?>[] actualTypes) {
        Assert.notEmpty((Object[])actualTypes, (String)"Should be always non empty.");
        Constructor<?> constructor = ClassUtils.obtainConstructor(type.getConstructors(), actualTypes);
        if (constructor != null) {
            return constructor;
        }
        return ClassUtils.obtainConstructor(type.getDeclaredConstructors(), actualTypes);
    }

    private static <T> Constructor<T> obtainConstructor(Constructor<T>[] constructors, Class<?>[] actualTypes) {
        if (ArrayUtils.isEmpty((Object[])constructors)) {
            return null;
        }
        for (Constructor<T> constructor : constructors) {
            if (!ClassUtils.matches(constructor.getParameterTypes(), actualTypes)) continue;
            return constructor;
        }
        return null;
    }

    private static Method obtainMethod(Object caller, String methodName, Class<?>[] actualTypes) {
        Assert.notEmpty((Object[])actualTypes, (String)"Should be always non empty.");
        Tuple2<Class<?>, Predicates> tuple = ClassUtils.obtainClass(caller);
        Method method = ClassUtils.obtainMethod(((Class)tuple.a).getMethods(), methodName, (Predicates)((Object)tuple.b), actualTypes);
        if (method != null) {
            return method;
        }
        return ClassUtils.obtainMethod(((Class)tuple.a).getDeclaredMethods(), methodName, (Predicates)((Object)tuple.b), actualTypes);
    }

    private static Method obtainMethod(Method[] methods, String methodName, Predicates flag, Class<?>[] actualTypes) {
        if (ArrayUtils.isEmpty((Object[])methods)) {
            return null;
        }
        for (Method method : methods) {
            boolean matches;
            boolean bl = matches = method.getName().equals(methodName) && !method.isSynthetic() && flag.equals(Modifier.isStatic(method.getModifiers())) && ClassUtils.matches(method.getParameterTypes(), actualTypes);
            if (!matches) continue;
            return method;
        }
        return null;
    }

    private static boolean matches(Class<?>[] definedTypes, Class<?>[] actualTypes) {
        if (definedTypes.length != actualTypes.length) {
            return false;
        }
        int n = definedTypes.length;
        for (int i = 0; i < n; ++i) {
            Class<?> definedType = definedTypes[i];
            Class<?> actualType = actualTypes[i];
            if (definedType.isPrimitive()) {
                PrimitiveTypes ept = PrimitiveTypes.ofPrimitive(definedType);
                PrimitiveTypes apt = PrimitiveTypes.ofPrimitiveOrWrapper(actualType);
                if (apt != null && apt.isCastable(ept)) continue;
                return false;
            }
            if (actualType == null || definedType.isAssignableFrom(actualType)) continue;
            return false;
        }
        return true;
    }

    private static String toString(Class<?>[] parameterTypes) {
        return ArrayUtils.isEmpty((Object[])parameterTypes) ? "()" : "(" + Joiner.on((String)", ").join((Object[])parameterTypes) + ")";
    }

    private static String decodeURL(URL url) {
        try {
            return URLDecoder.decode(Objects.requireNonNull(url).getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return (String)ExceptionUtils.rethrow((Throwable)e);
        }
    }
}

