/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import cn.ponfee.disjob.common.date.JacksonDate;
import cn.ponfee.disjob.common.date.JavaUtilDateFormat;
import cn.ponfee.disjob.common.date.LocalDateTimeFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.util.Assert;

@ThreadSafe
public final class Jsons {
    public static final TypeReference<Map<String, Object>> MAP_NORMAL = new TypeReference<Map<String, Object>>(){};
    public static final TypeReference<List<String>> LIST_STRING = new TypeReference<List<String>>(){};
    public static final Jsons NORMAL = new Jsons(JsonInclude.Include.NON_NULL);
    public static final Jsons ALL = new Jsons(null);
    public static final ObjectMapper JSON5 = Jsons.createObjectMapper(JsonInclude.Include.NON_NULL).enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_SINGLE_QUOTES.mappedFeature()}).enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature()}).enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()}).enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_TRAILING_COMMA.mappedFeature()}).enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_JAVA_COMMENTS.mappedFeature()});
    private final ObjectMapper objectMapper;

    private Jsons(JsonInclude.Include include) {
        this.objectMapper = Jsons.createObjectMapper(include);
    }

    public void write(OutputStream output, Object target) {
        try {
            this.objectMapper.writeValue(output, target);
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public String string(Object target) {
        try {
            return this.objectMapper.writeValueAsString(target);
        }
        catch (IOException e) {
            return (String)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public byte[] bytes(Object target) {
        try {
            return this.objectMapper.writeValueAsBytes(target);
        }
        catch (IOException e) {
            return (byte[])ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public <T> T parse(String json, JavaType javaType) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(json, javaType);
        }
        catch (Exception e) {
            return (T)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public <T> T parse(byte[] json, JavaType javaType) {
        if (json == null || json.length == 0) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(json, javaType);
        }
        catch (Exception e) {
            return (T)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public <T> T parse(String json, Class<T> target) {
        return this.parse(json, this.objectMapper.constructType(target));
    }

    public <T> T parse(byte[] json, Class<T> target) {
        return this.parse(json, this.objectMapper.constructType(target));
    }

    public <T> T parse(String json, Type type) {
        return this.parse(json, this.objectMapper.constructType(type));
    }

    public <T> T parse(byte[] json, Type type) {
        return this.parse(json, this.objectMapper.constructType(type));
    }

    public <T> T parse(String json, TypeReference<T> type) {
        return this.parse(json, this.objectMapper.constructType(type));
    }

    public <T> T parse(byte[] json, TypeReference<T> type) {
        return this.parse(json, this.objectMapper.constructType(type));
    }

    public static String toJson(Object target) {
        return NORMAL.string(target);
    }

    public static byte[] toBytes(Object target) {
        return NORMAL.bytes(target);
    }

    public static Object[] parseArray(String body, Class<?> ... types) {
        if (body == null) {
            return null;
        }
        ObjectMapper objectMapper = Jsons.NORMAL.objectMapper;
        JsonNode rootNode = Jsons.readTree(objectMapper, body);
        Assert.isTrue((boolean)rootNode.isArray(), (String)"Not array json data.");
        ArrayNode arrayNode = (ArrayNode)rootNode;
        if (types.length == 1 && arrayNode.size() > 1) {
            return new Object[]{Jsons.parse(objectMapper, (JsonNode)arrayNode, types[0])};
        }
        Object[] result = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = Jsons.parse(objectMapper, arrayNode.get(i), types[i]);
        }
        return result;
    }

    public static Object[] parseMethodArgs(String body, Method method) {
        return Jsons.parseArgs(body, method.getGenericParameterTypes());
    }

    public static Object[] parseArgs(String body, Type[] parameterTypes) {
        if (body == null) {
            return null;
        }
        int argumentCount = parameterTypes.length;
        if (argumentCount == 0) {
            return null;
        }
        ObjectMapper objectMapper = Jsons.NORMAL.objectMapper;
        JsonNode rootNode = Jsons.readTree(objectMapper, body);
        if (rootNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)rootNode;
            if (argumentCount == 1 && arrayNode.size() > 1) {
                return new Object[]{Jsons.parse(objectMapper, (JsonNode)arrayNode, parameterTypes[0])};
            }
            if (argumentCount != arrayNode.size()) {
                throw new IllegalArgumentException("Inconsistent method arguments size: " + argumentCount + " != " + arrayNode.size());
            }
            Object[] methodArguments = new Object[argumentCount];
            for (int i = 0; i < argumentCount; ++i) {
                methodArguments[i] = Jsons.parse(objectMapper, arrayNode.get(i), parameterTypes[i]);
            }
            return methodArguments;
        }
        Assert.isTrue((argumentCount == 1 ? 1 : 0) != 0, (String)"Single object request parameter not support multiple arguments method.");
        return new Object[]{Jsons.parse(objectMapper, rootNode, parameterTypes[0])};
    }

    public static <T> T fromJson(String json, JavaType javaType) {
        return NORMAL.parse(json, javaType);
    }

    public static <T> T fromJson(byte[] json, JavaType javaType) {
        return NORMAL.parse(json, javaType);
    }

    public static <T> T fromJson(String json, Class<T> target) {
        return NORMAL.parse(json, target);
    }

    public static <T> T fromJson(byte[] json, Class<T> target) {
        return NORMAL.parse(json, target);
    }

    public static <T> T fromJson(String json, Type target) {
        return NORMAL.parse(json, target);
    }

    public static <T> T fromJson(byte[] json, Type target) {
        return NORMAL.parse(json, target);
    }

    public static <T> T fromJson(String json, TypeReference<T> type) {
        return NORMAL.parse(json, type);
    }

    public static <T> T fromJson(byte[] json, TypeReference<T> type) {
        return NORMAL.parse(json, type);
    }

    public static ObjectMapper createObjectMapper(JsonInclude.Include include) {
        JsonFactory jsonFactory = ((JsonFactoryBuilder)new JsonFactoryBuilder().disable(JsonFactory.Feature.INTERN_FIELD_NAMES)).build();
        ObjectMapper objectMapper = new ObjectMapper(jsonFactory);
        if (include != null) {
            objectMapper.setSerializationInclusion(include);
        }
        Jsons.configObjectMapper(objectMapper);
        return objectMapper;
    }

    public static void configObjectMapper(ObjectMapper objectMapper) {
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        objectMapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN});
        objectMapper.disable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES});
        objectMapper.enable(new JsonGenerator.Feature[]{JsonWriteFeature.QUOTE_FIELD_NAMES.mappedFeature()});
        objectMapper.setTimeZone(JavaUtilDateFormat.DEFAULT.getTimeZone());
        objectMapper.setDateFormat((DateFormat)JavaUtilDateFormat.DEFAULT);
        Jsons.registerSimpleModule(objectMapper);
        Jsons.registerJavaTimeModule(objectMapper);
        objectMapper.registerModule((Module)new Jdk8Module());
    }

    public static void registerSimpleModule(ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Date.class, JacksonDate.INSTANCE.serializer());
        simpleModule.addDeserializer(Date.class, JacksonDate.INSTANCE.deserializer());
        objectMapper.registerModule((Module)simpleModule);
    }

    public static void registerJavaTimeModule(ObjectMapper objectMapper) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(dateTimeFormatter));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new JsonDeserializer<LocalDateTime>(){

            public LocalDateTime deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
                String text = parser.getText();
                return StringUtils.isBlank((CharSequence)text) ? null : LocalDateTimeFormat.DEFAULT.parse(text);
            }
        });
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(dateFormatter));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new JsonDeserializer<LocalDate>(){

            public LocalDate deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
                String text = parser.getText();
                return StringUtils.isBlank((CharSequence)text) ? null : LocalDateTimeFormat.DEFAULT.parse(text).toLocalDate();
            }
        });
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(timeFormatter));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(timeFormatter));
        objectMapper.registerModule((Module)javaTimeModule);
    }

    private static JsonNode readTree(ObjectMapper objectMapper, String body) {
        try {
            return objectMapper.readTree(body);
        }
        catch (JsonProcessingException e) {
            return (JsonNode)ExceptionUtils.rethrow((Throwable)e);
        }
    }

    private static Object parse(ObjectMapper objectMapper, JsonNode jsonNode, Type type) {
        try {
            return objectMapper.readerFor(objectMapper.getTypeFactory().constructType(type)).with(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).readValue(objectMapper.treeAsTokens((TreeNode)jsonNode));
        }
        catch (IOException e) {
            return ExceptionUtils.rethrow((Throwable)e);
        }
    }
}

