/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.date.JavaUtilDateFormat;
import cn.ponfee.disjob.common.util.ClassUtils;
import cn.ponfee.disjob.common.util.Enums;
import cn.ponfee.disjob.common.util.Numbers;
import cn.ponfee.disjob.common.util.PrimitiveTypes;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class ObjectUtils {
    private static final Pattern PATTERN_DATE = Pattern.compile("^([1-9]\\d{3}((0[1-9]|1[012])(0[1-9]|1\\d|2[0-8])|(0[13456789]|1[012])(29|30)|(0[13578]|1[02])31)|(([2-9]\\d)(0[48]|[2468][048]|[13579][26])|(([2468][048]|[3579][26])00))0229)(([0-1][0-9]|2[0-3])([0-5][0-9])([0-5][0-9])(\\d{3})?)?$");

    public static String toString(Object obj) {
        return ObjectUtils.toString(obj, "null");
    }

    public static String toString(Object obj, String defaultStr) {
        return obj == null ? defaultStr : ToStringBuilder.reflectionToString((Object)obj, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public static boolean isEmpty(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof CharSequence) {
            return ((CharSequence)o).length() == 0;
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o) == 0;
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty();
        }
        if (o instanceof Dictionary) {
            return ((Dictionary)o).isEmpty();
        }
        return false;
    }

    public static Object getValue(Object obj, String name) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(name);
        }
        if (obj instanceof Dictionary) {
            return ((Dictionary)obj).get(name);
        }
        try {
            return FieldUtils.readField((Object)obj, (String)name, (boolean)true);
        }
        catch (IllegalAccessException e) {
            return ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public static <T> T cast(Object value, Class<T> type) {
        if (type.isInstance(value)) {
            return (T)value;
        }
        PrimitiveOrWrapperConvertors convertor = PrimitiveOrWrapperConvertors.of(type);
        if (convertor != null) {
            return convertor.to(value);
        }
        if (value == null) {
            return null;
        }
        if (type.isArray()) {
            T[] array = Collects.newArray(type, 1);
            array[0] = ObjectUtils.cast(value, type.getComponentType());
            return (T)array;
        }
        if (type.isEnum()) {
            return (T)(value instanceof Number ? type.getEnumConstants()[((Number)value).intValue()] : EnumUtils.getEnumIgnoreCase(type, (String)value.toString()));
        }
        if (Date.class == type) {
            if (value instanceof Number) {
                return (T)new Date(((Number)value).longValue());
            }
            String text = value.toString();
            if (StringUtils.isNumeric((CharSequence)text) && !ObjectUtils.isDatePattern(text)) {
                return (T)new Date(Numbers.toLong(text));
            }
            try {
                return (T)JavaUtilDateFormat.DEFAULT.parse(text);
            }
            catch (ParseException e) {
                return (T)ExceptionUtils.rethrow((Throwable)e);
            }
        }
        return ClassUtils.newInstance(type, new Object[]{value.toString()});
    }

    public static <T> T newInstance(Class<T> type) {
        if (Map.class == type) {
            return (T)new HashMap(8);
        }
        if (Set.class == type) {
            return (T)new HashSet();
        }
        if (Collection.class == type || List.class == type) {
            return (T)new ArrayList();
        }
        if (Dictionary.class == type) {
            return (T)new Hashtable();
        }
        if (type.isPrimitive() || PrimitiveTypes.isWrapperType(type)) {
            Class<?> wrapper = PrimitiveTypes.ofPrimitiveOrWrapper(type).wrapper();
            return (T)ClassUtils.newInstance(wrapper, new Class[]{String.class}, new Object[]{"0"});
        }
        return ClassUtils.newInstance(type);
    }

    public static <T> void applyIfNotNull(T obj, Consumer<T> consumer) {
        if (obj != null) {
            consumer.accept(obj);
        }
    }

    private static boolean isDatePattern(String text) {
        return text != null && PATTERN_DATE.matcher(text).matches();
    }

    private static enum PrimitiveOrWrapperConvertors {
        BOOLEAN((Class)Boolean.TYPE){

            public Boolean to(Object value) {
                return Numbers.toBoolean(value);
            }
        }
        ,
        WRAP_BOOLEAN((Class)Boolean.class){

            public Boolean to(Object value) {
                return Numbers.toWrapBoolean(value);
            }
        }
        ,
        BYTE((Class)Byte.TYPE){

            public Byte to(Object value) {
                return Numbers.toByte(value);
            }
        }
        ,
        WRAP_BYTE((Class)Byte.class){

            public Byte to(Object value) {
                return Numbers.toWrapByte(value);
            }
        }
        ,
        SHORT((Class)Short.TYPE){

            public Short to(Object value) {
                return Numbers.toShort(value);
            }
        }
        ,
        WRAP_SHORT((Class)Short.class){

            public Short to(Object value) {
                return Numbers.toWrapShort(value);
            }
        }
        ,
        CHAR((Class)Character.TYPE){

            public Character to(Object value) {
                return Character.valueOf(Numbers.toChar(value));
            }
        }
        ,
        WRAP_CHAR((Class)Character.class){

            public Character to(Object value) {
                return Numbers.toWrapChar(value);
            }
        }
        ,
        INT((Class)Integer.TYPE){

            public Integer to(Object value) {
                return Numbers.toInt(value);
            }
        }
        ,
        WRAP_INT((Class)Integer.class){

            public Integer to(Object value) {
                return Numbers.toWrapInt(value);
            }
        }
        ,
        LONG((Class)Long.TYPE){

            public Long to(Object value) {
                return Numbers.toLong(value);
            }
        }
        ,
        WRAP_LONG((Class)Long.class){

            public Long to(Object value) {
                return Numbers.toWrapLong(value);
            }
        }
        ,
        FLOAT((Class)Float.TYPE){

            public Float to(Object value) {
                return Float.valueOf(Numbers.toFloat(value));
            }
        }
        ,
        WRAP_FLOAT((Class)Float.class){

            public Float to(Object value) {
                return Numbers.toWrapFloat(value);
            }
        }
        ,
        DOUBLE((Class)Double.TYPE){

            public Double to(Object value) {
                return Numbers.toDouble(value);
            }
        }
        ,
        WRAP_DOUBLE((Class)Double.class){

            public Double to(Object value) {
                return Numbers.toWrapDouble(value);
            }
        };

        private static final Map<Class<?>, PrimitiveOrWrapperConvertors> MAPPING;
        private final Class<?> type;

        private PrimitiveOrWrapperConvertors(Class<?> type) {
            this.type = type;
        }

        abstract <T> T to(Object var1);

        public Class<?> type() {
            return this.type;
        }

        static PrimitiveOrWrapperConvertors of(Class<?> targetType) {
            return MAPPING.get(targetType);
        }

        static {
            MAPPING = Enums.toMap(PrimitiveOrWrapperConvertors.class, PrimitiveOrWrapperConvertors::type);
        }
    }
}

