/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import java.lang.reflect.Proxy;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.support.AopUtils;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.InvocationHandler;

public final class ProxyUtils {
    public static <T> T create(java.lang.reflect.InvocationHandler invocationHandler, Class<?> ... interfaces) {
        return (T)Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, invocationHandler);
    }

    public static <T> T create(InvocationHandler invocationHandler, Class<?> superClass) {
        return (T)Enhancer.create(superClass, (Callback)invocationHandler);
    }

    public static <T, H extends java.lang.reflect.InvocationHandler & InvocationHandler> T create(H invocationHandler, Class<?> cls) {
        if (cls.isInterface()) {
            return ProxyUtils.create(invocationHandler, new Class[]{cls});
        }
        return ProxyUtils.create(invocationHandler, cls);
    }

    public static Object getTargetObject(Object object) throws Exception {
        if (!AopUtils.isAopProxy((Object)object)) {
            return object;
        }
        if (object instanceof Advised) {
            return ((Advised)object).getTargetSource().getTarget();
        }
        if (AopUtils.isJdkDynamicProxy((Object)object)) {
            return ProxyUtils.getProxyTargetObject(FieldUtils.readField((Object)object, (String)"h", (boolean)true));
        }
        if (AopUtils.isCglibProxy((Object)object)) {
            return ProxyUtils.getProxyTargetObject(FieldUtils.readField((Object)object, (String)"CGLIB$CALLBACK_0", (boolean)true));
        }
        return object;
    }

    private static Object getProxyTargetObject(Object proxy) throws Exception {
        AdvisedSupport advisedSupport = (AdvisedSupport)FieldUtils.readField((Object)proxy, (String)"advised", (boolean)true);
        return advisedSupport.getTargetSource().getTarget();
    }
}

