/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SystemUtils.class);

    public static String getConfig(String name) {
        String value = null;
        try {
            value = System.getProperty(name);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                return value;
            }
        }
        catch (Exception e) {
            LOG.error("Get system property occur error: " + name, (Throwable)e);
        }
        try {
            value = System.getenv(name);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                return value;
            }
        }
        catch (Exception e) {
            LOG.error("Get system env occur error: " + name, (Throwable)e);
        }
        return value;
    }

    public static String getConfig(String name, String defaultValue) {
        String value = SystemUtils.getConfig(name);
        return value != null ? value : defaultValue;
    }
}

