/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.common.util;

import cn.ponfee.disjob.common.util.Bytes;
import java.util.Base64;
import java.util.UUID;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.IdGenerator;

public final class UuidUtils {
    private static final IdGenerator UUID_GENERATOR = new AlternativeJdkIdGenerator();

    public static byte[] uuid() {
        UUID uuid = UUID_GENERATOR.generateId();
        byte[] value = new byte[16];
        Bytes.put(uuid.getMostSignificantBits(), value, 0);
        Bytes.put(uuid.getLeastSignificantBits(), value, 8);
        return value;
    }

    public static String uuid32() {
        UUID uuid = UUID_GENERATOR.generateId();
        return Bytes.toHex(uuid.getMostSignificantBits(), true) + Bytes.toHex(uuid.getLeastSignificantBits(), true);
    }

    public static String uuid22() {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(UuidUtils.uuid());
    }
}

