/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import java.util.Map;
import java.util.Objects;

public enum CollisionStrategy implements IntValueEnum<CollisionStrategy>
{
    CONCURRENT(1),
    SERIAL(2),
    OVERRIDE(3),
    DISCARD(4);

    private static final Map<Integer, CollisionStrategy> MAPPING;
    private final int value;

    private CollisionStrategy(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static CollisionStrategy of(Integer value) {
        return Objects.requireNonNull(MAPPING.get(value), () -> "Invalid collision strategy value: " + value);
    }

    static {
        MAPPING = Enums.toMap(CollisionStrategy.class, CollisionStrategy::value);
    }
}

