/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import cn.ponfee.disjob.core.enums.RunState;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum ExecuteState implements IntValueEnum<ExecuteState>
{
    WAITING(10, RunState.WAITING),
    EXECUTING(20, RunState.RUNNING),
    PAUSED(30, RunState.PAUSED),
    FINISHED(40, RunState.FINISHED),
    INSTANCE_FAILED(50, RunState.CANCELED),
    VERIFY_FAILED(51, RunState.CANCELED),
    INIT_EXCEPTION(52, RunState.CANCELED),
    EXECUTE_FAILED(53, RunState.CANCELED),
    EXECUTE_EXCEPTION(54, RunState.CANCELED),
    EXECUTE_TIMEOUT(55, RunState.CANCELED),
    EXECUTE_COLLISION(56, RunState.CANCELED),
    MANUAL_CANCELED(57, RunState.CANCELED),
    WAITING_CANCELED(58, RunState.CANCELED);

    public static final List<ExecuteState> PAUSABLE_LIST;
    public static final List<ExecuteState> EXECUTABLE_LIST;
    private static final Map<Integer, ExecuteState> MAPPING;
    private final int value;
    private final RunState runState;

    private ExecuteState(int value, RunState runState) {
        this.value = value;
        this.runState = runState;
    }

    public int value() {
        return this.value;
    }

    public boolean isTerminal() {
        return this.runState.isTerminal();
    }

    public boolean isFailure() {
        return this.runState.isFailure();
    }

    public RunState runState() {
        return this.runState;
    }

    public static ExecuteState of(Integer value) {
        return Objects.requireNonNull(MAPPING.get(value), () -> "Invalid execute state value: " + value);
    }

    static {
        PAUSABLE_LIST = ImmutableList.of((Object)((Object)WAITING), (Object)((Object)EXECUTING));
        EXECUTABLE_LIST = ImmutableList.of((Object)((Object)WAITING), (Object)((Object)PAUSED));
        MAPPING = Enums.toMap(ExecuteState.class, ExecuteState::value);
    }
}

