/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.core.enums;

import cn.ponfee.disjob.common.base.IntValueEnum;
import cn.ponfee.disjob.common.util.Enums;
import java.util.Map;
import java.util.Objects;

public enum JobType implements IntValueEnum<JobType>
{
    NORMAL(1),
    WORKFLOW(2);

    private static final Map<Integer, JobType> MAPPING;
    private final int value;

    private JobType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static JobType of(Integer value) {
        return Objects.requireNonNull(MAPPING.get(value), () -> "Invalid job type value: " + value);
    }

    static {
        MAPPING = Enums.toMap(JobType.class, JobType::value);
    }
}

